/*******************************************************************************
 *
 *	Font metric data for ITC Avant Garde Gothic Book Oblique
 *
 *	Copyright 2001 Ian Pilcher
 *
 *
 *	See dlls/wineps/data/COPYRIGHTS for font copyright information.
 *
 */

#include "psdrv.h"
#include "data/agl.h"


/*
 *  Glyph metrics
 */

static const AFMMETRICS metrics[228] = 
{
    {  32, 0x0020,  277, GN_space },
    {  33, 0x0021,  295, GN_exclam },
    {  34, 0x0022,  309, GN_quotedbl },
    {  35, 0x0023,  554, GN_numbersign },
    {  36, 0x0024,  554, GN_dollar },
    {  37, 0x0025,  775, GN_percent },
    {  38, 0x0026,  757, GN_ampersand },
    { 169, 0x0027,  198, GN_quotesingle },
    {  40, 0x0028,  369, GN_parenleft },
    {  41, 0x0029,  369, GN_parenright },
    {  42, 0x002a,  425, GN_asterisk },
    {  43, 0x002b,  606, GN_plus },
    {  44, 0x002c,  277, GN_comma },
    {  45, 0x002d,  332, GN_hyphen },
    {  46, 0x002e,  277, GN_period },
    {  47, 0x002f,  437, GN_slash },
    {  48, 0x0030,  554, GN_zero },
    {  49, 0x0031,  554, GN_one },
    {  50, 0x0032,  554, GN_two },
    {  51, 0x0033,  554, GN_three },
    {  52, 0x0034,  554, GN_four },
    {  53, 0x0035,  554, GN_five },
    {  54, 0x0036,  554, GN_six },
    {  55, 0x0037,  554, GN_seven },
    {  56, 0x0038,  554, GN_eight },
    {  57, 0x0039,  554, GN_nine },
    {  58, 0x003a,  277, GN_colon },
    {  59, 0x003b,  277, GN_semicolon },
    {  60, 0x003c,  606, GN_less },
    {  61, 0x003d,  606, GN_equal },
    {  62, 0x003e,  606, GN_greater },
    {  63, 0x003f,  591, GN_question },
    {  64, 0x0040,  867, GN_at },
    {  65, 0x0041,  740, GN_A },
    {  66, 0x0042,  574, GN_B },
    {  67, 0x0043,  813, GN_C },
    {  68, 0x0044,  744, GN_D },
    {  69, 0x0045,  536, GN_E },
    {  70, 0x0046,  485, GN_F },
    {  71, 0x0047,  872, GN_G },
    {  72, 0x0048,  683, GN_H },
    {  73, 0x0049,  226, GN_I },
    {  74, 0x004a,  482, GN_J },
    {  75, 0x004b,  591, GN_K },
    {  76, 0x004c,  462, GN_L },
    {  77, 0x004d,  919, GN_M },
    {  78, 0x004e,  740, GN_N },
    {  79, 0x004f,  869, GN_O },
    {  80, 0x0050,  592, GN_P },
    {  81, 0x0051,  871, GN_Q },
    {  82, 0x0052,  607, GN_R },
    {  83, 0x0053,  498, GN_S },
    {  84, 0x0054,  426, GN_T },
    {  85, 0x0055,  655, GN_U },
    {  86, 0x0056,  702, GN_V },
    {  87, 0x0057,  960, GN_W },
    {  88, 0x0058,  609, GN_X },
    {  89, 0x0059,  592, GN_Y },
    {  90, 0x005a,  480, GN_Z },
    {  91, 0x005b,  351, GN_bracketleft },
    {  92, 0x005c,  605, GN_backslash },
    {  93, 0x005d,  351, GN_bracketright },
    {  94, 0x005e,  606, GN_asciicircum },
    {  95, 0x005f,  500, GN_underscore },
    { 193, 0x0060,  378, GN_grave },
    {  97, 0x0061,  683, GN_a },
    {  98, 0x0062,  682, GN_b },
    {  99, 0x0063,  647, GN_c },
    { 100, 0x0064,  685, GN_d },
    { 101, 0x0065,  650, GN_e },
    { 102, 0x0066,  314, GN_f },
    { 103, 0x0067,  673, GN_g },
    { 104, 0x0068,  610, GN_h },
    { 105, 0x0069,  200, GN_i },
    { 106, 0x006a,  203, GN_j },
    { 107, 0x006b,  502, GN_k },
    { 108, 0x006c,  200, GN_l },
    { 109, 0x006d,  938, GN_m },
    { 110, 0x006e,  610, GN_n },
    { 111, 0x006f,  655, GN_o },
    { 112, 0x0070,  682, GN_p },
    { 113, 0x0071,  682, GN_q },
    { 114, 0x0072,  301, GN_r },
    { 115, 0x0073,  388, GN_s },
    { 116, 0x0074,  339, GN_t },
    { 117, 0x0075,  608, GN_u },
    { 118, 0x0076,  554, GN_v },
    { 119, 0x0077,  831, GN_w },
    { 120, 0x0078,  480, GN_x },
    { 121, 0x0079,  536, GN_y },
    { 122, 0x007a,  425, GN_z },
    { 123, 0x007b,  351, GN_braceleft },
    { 124, 0x007c,  672, GN_bar },
    { 125, 0x007d,  351, GN_braceright },
    { 126, 0x007e,  606, GN_asciitilde },
    { 161, 0x00a1,  295, GN_exclamdown },
    { 162, 0x00a2,  554, GN_cent },
    { 163, 0x00a3,  554, GN_sterling },
    { 168, 0x00a4,  554, GN_currency },
    { 165, 0x00a5,  554, GN_yen },
    {  -1, 0x00a6,  672, GN_brokenbar },
    { 167, 0x00a7,  615, GN_section },
    { 200, 0x00a8,  369, GN_dieresis },
    {  -1, 0x00a9,  747, GN_copyright },
    { 227, 0x00aa,  369, GN_ordfeminine },
    { 171, 0x00ab,  425, GN_guillemotleft },
    {  -1, 0x00ac,  606, GN_logicalnot },
    {  -1, 0x00ae,  747, GN_registered },
    {  -1, 0x00b0,  400, GN_degree },
    {  -1, 0x00b1,  606, GN_plusminus },
    {  -1, 0x00b2,  332, GN_twosuperior },
    {  -1, 0x00b3,  332, GN_threesuperior },
    { 194, 0x00b4,  375, GN_acute },
    { 182, 0x00b6,  564, GN_paragraph },
    { 180, 0x00b7,  277, GN_periodcentered },
    { 203, 0x00b8,  324, GN_cedilla },
    {  -1, 0x00b9,  332, GN_onesuperior },
    { 235, 0x00ba,  369, GN_ordmasculine },
    { 187, 0x00bb,  425, GN_guillemotright },
    {  -1, 0x00bc,  831, GN_onequarter },
    {  -1, 0x00bd,  831, GN_onehalf },
    {  -1, 0x00be,  831, GN_threequarters },
    { 191, 0x00bf,  591, GN_questiondown },
    {  -1, 0x00c0,  740, GN_Agrave },
    {  -1, 0x00c1,  740, GN_Aacute },
    {  -1, 0x00c2,  740, GN_Acircumflex },
    {  -1, 0x00c3,  740, GN_Atilde },
    {  -1, 0x00c4,  740, GN_Adieresis },
    {  -1, 0x00c5,  740, GN_Aring },
    { 225, 0x00c6,  992, GN_AE },
    {  -1, 0x00c7,  813, GN_Ccedilla },
    {  -1, 0x00c8,  536, GN_Egrave },
    {  -1, 0x00c9,  536, GN_Eacute },
    {  -1, 0x00ca,  536, GN_Ecircumflex },
    {  -1, 0x00cb,  536, GN_Edieresis },
    {  -1, 0x00cc,  226, GN_Igrave },
    {  -1, 0x00cd,  226, GN_Iacute },
    {  -1, 0x00ce,  226, GN_Icircumflex },
    {  -1, 0x00cf,  226, GN_Idieresis },
    {  -1, 0x00d0,  790, GN_Eth },
    {  -1, 0x00d1,  740, GN_Ntilde },
    {  -1, 0x00d2,  869, GN_Ograve },
    {  -1, 0x00d3,  869, GN_Oacute },
    {  -1, 0x00d4,  869, GN_Ocircumflex },
    {  -1, 0x00d5,  869, GN_Otilde },
    {  -1, 0x00d6,  869, GN_Odieresis },
    {  -1, 0x00d7,  606, GN_multiply },
    { 233, 0x00d8,  868, GN_Oslash },
    {  -1, 0x00d9,  655, GN_Ugrave },
    {  -1, 0x00da,  655, GN_Uacute },
    {  -1, 0x00db,  655, GN_Ucircumflex },
    {  -1, 0x00dc,  655, GN_Udieresis },
    {  -1, 0x00dd,  592, GN_Yacute },
    {  -1, 0x00de,  592, GN_Thorn },
    { 251, 0x00df,  554, GN_germandbls },
    {  -1, 0x00e0,  683, GN_agrave },
    {  -1, 0x00e1,  683, GN_aacute },
    {  -1, 0x00e2,  683, GN_acircumflex },
    {  -1, 0x00e3,  683, GN_atilde },
    {  -1, 0x00e4,  683, GN_adieresis },
    {  -1, 0x00e5,  683, GN_aring },
    { 241, 0x00e6, 1157, GN_ae },
    {  -1, 0x00e7,  647, GN_ccedilla },
    {  -1, 0x00e8,  650, GN_egrave },
    {  -1, 0x00e9,  650, GN_eacute },
    {  -1, 0x00ea,  650, GN_ecircumflex },
    {  -1, 0x00eb,  650, GN_edieresis },
    {  -1, 0x00ec,  200, GN_igrave },
    {  -1, 0x00ed,  200, GN_iacute },
    {  -1, 0x00ee,  200, GN_icircumflex },
    {  -1, 0x00ef,  200, GN_idieresis },
    {  -1, 0x00f0,  655, GN_eth },
    {  -1, 0x00f1,  610, GN_ntilde },
    {  -1, 0x00f2,  655, GN_ograve },
    {  -1, 0x00f3,  655, GN_oacute },
    {  -1, 0x00f4,  655, GN_ocircumflex },
    {  -1, 0x00f5,  655, GN_otilde },
    {  -1, 0x00f6,  655, GN_odieresis },
    {  -1, 0x00f7,  606, GN_divide },
    { 249, 0x00f8,  653, GN_oslash },
    {  -1, 0x00f9,  608, GN_ugrave },
    {  -1, 0x00fa,  608, GN_uacute },
    {  -1, 0x00fb,  608, GN_ucircumflex },
    {  -1, 0x00fc,  608, GN_udieresis },
    {  -1, 0x00fd,  536, GN_yacute },
    {  -1, 0x00fe,  682, GN_thorn },
    {  -1, 0x00ff,  536, GN_ydieresis },
    { 245, 0x0131,  200, GN_dotlessi },
    { 232, 0x0141,  517, GN_Lslash },
    { 248, 0x0142,  300, GN_lslash },
    { 234, 0x0152, 1194, GN_OE },
    { 250, 0x0153, 1137, GN_oe },
    {  -1, 0x0160,  498, GN_Scaron },
    {  -1, 0x0161,  388, GN_scaron },
    {  -1, 0x0178,  592, GN_Ydieresis },
    {  -1, 0x017d,  480, GN_Zcaron },
    {  -1, 0x017e,  425, GN_zcaron },
    { 166, 0x0192,  554, GN_florin },
    { 195, 0x02c6,  502, GN_circumflex },
    { 207, 0x02c7,  502, GN_caron },
    { 197, 0x02c9,  485, GN_macron },
    { 198, 0x02d8,  453, GN_breve },
    { 199, 0x02d9,  222, GN_dotaccent },
    { 202, 0x02da,  332, GN_ring },
    { 206, 0x02db,  302, GN_ogonek },
    { 196, 0x02dc,  439, GN_tilde },
    { 205, 0x02dd,  552, GN_hungarumlaut },
    {  -1, 0x03bc,  608, GN_mu },
    { 177, 0x2013,  500, GN_endash },
    { 208, 0x2014, 1000, GN_emdash },
    {  96, 0x2018,  351, GN_quoteleft },
    {  39, 0x2019,  351, GN_quoteright },
    { 184, 0x201a,  354, GN_quotesinglbase },
    { 170, 0x201c,  502, GN_quotedblleft },
    { 186, 0x201d,  484, GN_quotedblright },
    { 185, 0x201e,  502, GN_quotedblbase },
    { 178, 0x2020,  553, GN_dagger },
    { 179, 0x2021,  553, GN_daggerdbl },
    { 183, 0x2022,  606, GN_bullet },
    { 188, 0x2026, 1000, GN_ellipsis },
    { 189, 0x2030, 1174, GN_perthousand },
    { 172, 0x2039,  251, GN_guilsinglleft },
    { 173, 0x203a,  251, GN_guilsinglright },
    {  -1, 0x2122, 1000, GN_trademark },
    {  -1, 0x2212,  606, GN_minus },
    { 164, 0x2215,  166, GN_fraction },
    { 174, 0xfb01,  487, GN_fi },
    { 175, 0xfb02,  485, GN_fl }
};


/*
 *  Font metrics
 */

const AFM PSDRV_AvantGarde_BookOblique =
{
    "AvantGarde-BookOblique",		    /* FontName */
    "ITC Avant Garde Gothic Book Oblique",  /* FullName */
    "ITC Avant Garde Gothic",		    /* FamilyName */
    "AdobeStandardEncoding",		    /* EncodingScheme */
    FW_NORMAL,				    /* Weight */
    -10.5,				    /* ItalicAngle */
    FALSE,				    /* IsFixedPitch */
    -100,				    /* UnderlinePosition */
    50,					    /* UnderlineThickness */
    { -113, -222, 1279, 955 },		    /* FontBBox */
    740,				    /* Ascender */
    -192,				    /* Descender */
    {
	1000,				    /* WinMetrics.usUnitsPerEm */
	1006,				    /* WinMetrics.sAscender */
	-220,				    /* WinMetrics.sDescender */
	0,				    /* WinMetrics.sLineGap */
	486,				    /* WinMetrics.sAvgCharWidth */
	750,				    /* WinMetrics.sTypoAscender */
	-208,				    /* WinMetrics.sTypoDescender */
	112,				    /* WinMetrics.sTypoLineGap */
	971,				    /* WinMetrics.usWinAscent */
	220				    /* WinMetrics.usWinDescent */
    },
    228,				    /* NumofMetrics */
    metrics				    /* Metrics */
};
