/*
 * dlls/advapi32/crypt.c
 */
#include <time.h>
#include <stdlib.h>

#include "windef.h"
#include "winerror.h"
#include "wincrypt.h"
#include "debugtools.h"

DEFAULT_DEBUG_CHANNEL(advapi);

/******************************************************************************
 * CryptAcquireContextA (ADVAPI32.@)
 * Acquire a crypto provider context handle.
 *
 * PARAMS
 * phProv: Pointer to HCRYPTPROV for the output.
 * pszContainer: FIXME (unknown)
 * pszProvider: FIXME (unknown)
 * dwProvType: Crypto provider type to get a handle.
 * dwFlags: flags for the operation
 *
 * RETURNS TRUE on success, FALSE on failure.
 */
BOOL WINAPI CryptAcquireContextA (HCRYPTPROV *phProv, LPCSTR pszContainer,
		LPCSTR pszProvider, DWORD dwProvType, DWORD dwFlags)
{
	FIXME("(%p, %s, %s, %ld, %08lx): stub!\n", phProv, pszContainer,
		pszProvider, dwProvType, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptAcquireContextW (ADVAPI32.@)
 */
BOOL WINAPI CryptAcquireContextW (HCRYPTPROV *phProv, LPCWSTR pszContainer,
		LPCWSTR pszProvider, DWORD dwProvType, DWORD dwFlags)
{
	FIXME("(%p, %s, %s, %ld, %08lx): stub!\n", phProv, debugstr_w(pszContainer),
		debugstr_w(pszProvider), dwProvType, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptGenRandom (ADVAPI32.@)
 */
BOOL WINAPI CryptGenRandom (HCRYPTPROV hProv, DWORD dwLen, BYTE *pbBuffer)
{
	DWORD i;

	FIXME("(0x%lx, %ld, %p): stub!\n", hProv, dwLen, pbBuffer);
	/*
	FIXME: Currently this function is just a stub, it is missing functionality in
		the following (major) ways:
	(1) It makes no use of the passed in HCRYPTPROV handle. (ie. it doesn't
		use a cryptographic service provider (CSP)
	(2) It doesn't use the values in the passed in pbBuffer to further randomize
		its internal seed.
	(3) MSDN mentions that this function produces "cryptographically random"
		data, which is "... far more random than the data generated by the typical
		random number generator such as the one shipped with your C compiler".
		We are currently using the C runtime rand() function. ^_^

	See MSDN documentation for CryptGenRandom for more information.
	*/

	if (dwLen <= 0)
		return FALSE;

	srand(time(NULL));
	for (i=0; i<dwLen; i++)
	{
		*pbBuffer = (BYTE)(rand() % 256);
		pbBuffer++;
	}

	return TRUE;
}

/******************************************************************************
 * CryptContextAddRef (ADVAPI32.@)
 */
BOOL WINAPI CryptContextAddRef (HCRYPTPROV hProv, DWORD *pdwReserved, DWORD dwFlags)
{
	FIXME("(0x%lx, %p, %08lx): stub!\n", hProv, pdwReserved, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptCreateHash (ADVAPI32.@)
 */
BOOL WINAPI CryptCreateHash (HCRYPTPROV hProv, ALG_ID Algid, HCRYPTKEY hKey,
		DWORD dwFlags, HCRYPTHASH *phHash)
{
	FIXME("(0x%lx, 0x%x, 0x%lx, %08lx, %p): stub!\n", hProv, Algid, hKey, dwFlags, phHash);
	return FALSE;
}

/******************************************************************************
 * CryptDecrypt (ADVAPI32.@)
 */
BOOL WINAPI CryptDecrypt (HCRYPTKEY hKey, HCRYPTHASH hHash, BOOL Final,
		DWORD dwFlags, BYTE *pbData, DWORD *pdwDataLen)
{
	FIXME("(0x%lx, 0x%lx, %d, %08lx, %p, %p): stub!\n", hKey, hHash, Final, dwFlags, pbData, pdwDataLen);
	return FALSE;
}

/******************************************************************************
 * CryptDeriveKey (ADVAPI32.@)
 */
BOOL WINAPI CryptDeriveKey (HCRYPTPROV hProv, ALG_ID Algid, HCRYPTHASH hBaseData,
		DWORD dwFlags, HCRYPTKEY *phKey)
{
	FIXME("(0x%lx, %d, 0x%ld, %08ld, %p): stub!\n", hProv, Algid, hBaseData, dwFlags, phKey);
	return FALSE;
}

/******************************************************************************
 * CryptDestroyHash (ADVAPI32.@)
 */
BOOL WINAPI CryptDestroyHash (HCRYPTHASH hHash)
{
	FIXME("(0x%lx): stub!\n", hHash);
	return FALSE;
}

/******************************************************************************
 *  CryptDestroyKey (ADVAPI32.@)
 */
BOOL WINAPI CryptDestroyKey (HCRYPTKEY hKey)
{
	FIXME("(0x%lx): stub!\n", hKey);
	return FALSE;
}

/******************************************************************************
 * CryptDuplicateHash (ADVAPI32.@)
 */
BOOL WINAPI CryptDuplicateHash (HCRYPTHASH hHash, DWORD *pdwReserved,
		DWORD dwFlags, HCRYPTHASH *phHash)
{
	FIXME("(0x%lx, %p, %08ld, %p): stub!\n", hHash, pdwReserved, dwFlags, phHash);
	return FALSE;
}

/******************************************************************************
 * CryptDuplicateKey (ADVAPI32.@)
 */
BOOL WINAPI CryptDuplicateKey (HCRYPTKEY hKey, DWORD *pdwReserved, DWORD dwFlags, HCRYPTKEY *phKey)
{
	FIXME("(0x%lx, %p, %08ld, %p): stub!\n", hKey, pdwReserved, dwFlags, phKey);
	return FALSE;
}

/******************************************************************************
 * CryptEncrypt (ADVAPI32.@)
 */
BOOL WINAPI CryptEncrypt (HCRYPTKEY hKey, HCRYPTHASH hHash, BOOL Final,
		DWORD dwFlags, BYTE *pbData, DWORD *pdwDataLen, DWORD dwBufLen)
{
	FIXME("(0x%lx, 0x%lx, %d, %08ld, %p, %p, %ld): stub!\n", hKey, hHash, Final, dwFlags, pbData, pdwDataLen, dwBufLen);
	return FALSE;
}

/******************************************************************************
 * CryptEnumProvidersA (ADVAPI32.@)
 */
BOOL WINAPI CryptEnumProvidersA (DWORD dwIndex, DWORD *pdwReserved,
		DWORD dwFlags, DWORD *pdwProvType, LPSTR pszProvName, DWORD *pcbProvName)
{
	FIXME("(%ld, %p, %ld, %p, %p, %p): stub!\n", dwIndex, pdwReserved, dwFlags,
			pdwProvType, pszProvName, pcbProvName);
	return FALSE;
}

/******************************************************************************
 * CryptEnumProvidersW (ADVAPI32.@)
 */
BOOL WINAPI CryptEnumProvidersW (DWORD dwIndex, DWORD *pdwReserved,
		DWORD dwFlags, DWORD *pdwProvType, LPWSTR pszProvName, DWORD *pcbProvName)
{
	FIXME("(%ld, %p, %08ld, %p, %p, %p): stub!\n", dwIndex, pdwReserved, dwFlags,
			pdwProvType, pszProvName, pcbProvName);
	return FALSE;
}

/******************************************************************************
 * CryptEnumProviderTypesA (ADVAPI32.@)
 */
BOOL WINAPI CryptEnumProviderTypesA (DWORD dwIndex, DWORD *pdwReserved,
		DWORD dwFlags, DWORD *pdwProvType, LPSTR pszTypeName, DWORD *pcbTypeName)
{
	FIXME("(%ld, %p, %08ld, %p, %p, %p): stub!\n", dwIndex, pdwReserved, dwFlags, pdwProvType, pszTypeName, pcbTypeName);
	return FALSE;
}

/******************************************************************************
 * CryptEnumProviderTypesW (ADVAPI32.@)
 */
BOOL WINAPI CryptEnumProviderTypesW (DWORD dwIndex, DWORD *pdwReserved,
		DWORD dwFlags, DWORD *pdwProvType, LPWSTR pszTypeName, DWORD *pcbTypeName)
{
	FIXME("(%ld, %p, %08ld, %p, %p, %p): stub!\n", dwIndex, pdwReserved, dwFlags,
			pdwProvType, pszTypeName, pcbTypeName);
	return FALSE;
}

/******************************************************************************
 * CryptExportKey (ADVAPI32.@)
 */
BOOL WINAPI CryptExportKey (HCRYPTKEY hKey, HCRYPTKEY hExpKey, DWORD dwBlobType,
		DWORD dwFlags, BYTE *pbData, DWORD *pdwDataLen)
{
	FIXME("(0x%lx, 0x%lx, %ld, %08ld, %p, %p): stub!\n", hKey, hExpKey, dwBlobType, dwFlags, pbData, pdwDataLen);
	return FALSE;
}

/******************************************************************************
 * CryptGenKey (ADVAPI32.@)
 */
BOOL WINAPI CryptGenKey (HCRYPTPROV hProv, ALG_ID Algid, DWORD dwFlags, HCRYPTKEY *phKey)
{
	FIXME("(0x%lx, %d, %08ld, %p): stub!\n", hProv, Algid, dwFlags, phKey);
	return FALSE;
}

/******************************************************************************
 * CryptGetDefaultProviderA (ADVAPI32.@)
 */
BOOL WINAPI CryptGetDefaultProviderA (DWORD dwProvType, DWORD *pdwReserved,
		DWORD dwFlags, LPSTR pszProvName, DWORD *pcbProvName)
{
	FIXME("(%ld, %p, %ld, %p, %p): stub!\n", dwProvType, pdwReserved, dwFlags, pszProvName, pcbProvName);
	return FALSE;
}

/******************************************************************************
 * CryptGetDefaultProviderW (ADVAPI32.@)
 */
BOOL WINAPI CryptGetDefaultProviderW (DWORD dwProvType, DWORD *pdwReserved,
		DWORD dwFlags, LPWSTR pszProvName, DWORD *pcbProvName)
{
	FIXME("(%ld, %p, %08ld, %p, %p): stub!\n", dwProvType, pdwReserved, dwFlags, pszProvName, pcbProvName);
	return FALSE;
}

/******************************************************************************
 * CryptGetHashParam (ADVAPI32.@)
 */
BOOL WINAPI CryptGetHashParam (HCRYPTHASH hHash, DWORD dwParam, BYTE *pbData,
		DWORD *pdwDataLen, DWORD dwFlags)
{
	FIXME("(0x%lx, %ld, %p, %p, %08ld): stub!\n", hHash, dwParam, pbData, pdwDataLen, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptGetKeyParam (ADVAPI32.@)
 */
BOOL WINAPI CryptGetKeyParam (HCRYPTKEY hKey, DWORD dwParam, BYTE *pbData,
		DWORD *pdwDataLen, DWORD dwFlags)
{
	FIXME("(0x%lx, %ld, %p, %p, %08ld): stub!\n", hKey, dwParam, pbData, pdwDataLen, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptGetProvParam (ADVAPI32.@)
 */
BOOL WINAPI CryptGetProvParam (HCRYPTPROV hProv, DWORD dwParam, BYTE *pbData,
		DWORD *pdwDataLen, DWORD dwFlags)
{
	FIXME("(0x%lx, %ld, %p, %p, %08ld): stub!\n", hProv, dwParam, pbData, pdwDataLen, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptGetUserKey (ADVAPI32.@)
 */
BOOL WINAPI CryptGetUserKey (HCRYPTPROV hProv, DWORD dwKeySpec, HCRYPTKEY *phUserKey)
{
	FIXME("(0x%lx, %ld, %p): stub!\n", hProv, dwKeySpec, phUserKey);
	return FALSE;
}

/******************************************************************************
 * CryptHashData (ADVAPI32.@)
 */
BOOL WINAPI CryptHashData (HCRYPTHASH hHash, BYTE *pbData, DWORD dwDataLen, DWORD dwFlags)
{
	FIXME("(0x%lx, %p, %ld, %08ld): stub!\n", hHash, pbData, dwDataLen, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptHashSessionKey (ADVAPI32.@)
 */
BOOL WINAPI CryptHashSessionKey (HCRYPTHASH hHash, HCRYPTKEY hKey, DWORD dwFlags)
{
	FIXME("(0x%lx, 0x%lx, %08ld): stub!\n", hHash, hKey, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptImportKey (ADVAPI32.@)
 */
BOOL WINAPI CryptImportKey (HCRYPTPROV hProv, BYTE *pbData, DWORD dwDataLen,
		HCRYPTKEY hPubKey, DWORD dwFlags, HCRYPTKEY *phKey)
{
	FIXME("(0x%lx, %p, %ld, 0x%lx, %08ld, %p): stub!\n", hProv, pbData, dwDataLen, hPubKey, dwFlags, phKey);
	return FALSE;
}

/******************************************************************************
 * CryptReleaseContext (ADVAPI32.@)
 */
BOOL WINAPI CryptReleaseContext (HCRYPTPROV hProv, DWORD dwFlags)
{
	FIXME("(0x%lx, %08ld): stub!\n", hProv, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptSignHashA (ADVAPI32.@)
 */
BOOL WINAPI CryptSignHashA (HCRYPTHASH hHash, DWORD dwKeySpec, LPCSTR sDescription,
		DWORD dwFlags, BYTE *pbSignature, DWORD *pdwSigLen)
{
	FIXME("(0x%lx, %ld, %s, %08ld, %p, %p): stub!\n", hHash, dwKeySpec, sDescription, dwFlags, pbSignature, pdwSigLen);
	return FALSE;
}

/******************************************************************************
 * CryptSignHashW (ADVAPI32.@)
 */
BOOL WINAPI CryptSignHashW (HCRYPTHASH hHash, DWORD dwKeySpec, LPCWSTR sDescription,
		DWORD dwFlags, BYTE *pbSignature, DWORD *pdwSigLen)
{
	FIXME("(0x%lx, %ld, %s, %08ld, %p, %p): stub!\n", hHash, dwKeySpec, debugstr_w(sDescription), dwFlags, pbSignature, pdwSigLen);
	return FALSE;
}

/******************************************************************************
 * CryptSetHashParam (ADVAPI32.@)
 */
BOOL WINAPI CryptSetHashParam (HCRYPTHASH hHash, DWORD dwParam, BYTE *pbData, DWORD dwFlags)
{
	FIXME("(0x%lx, %ld, %p, %08ld): stub!\n", hHash, dwParam, pbData, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptSetKeyParam (ADVAPI32.@)
 */
BOOL WINAPI CryptSetKeyParam (HCRYPTKEY hKey, DWORD dwParam, BYTE *pbData, DWORD dwFlags)
{
	FIXME("(%lx, %lx, %p, %lx): stub!\n", hKey, dwParam, pbData, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptSetProviderA (ADVAPI32.@)
 */
BOOL WINAPI CryptSetProviderA (LPCSTR pszProvName, DWORD dwProvType)
{
	FIXME("(%s, %ld): stub!\n", pszProvName, dwProvType);
	return FALSE;
}

/******************************************************************************
 * CryptSetProviderW (ADVAPI32.@)
 */
BOOL WINAPI CryptSetProviderW (LPCWSTR pszProvName, DWORD dwProvType)
{
	FIXME("(%s, %ld): stub!\n", debugstr_w(pszProvName), dwProvType);
	return FALSE;
}

/******************************************************************************
 * CryptSetProviderEx (ADVAPI32.@)
 */
BOOL WINAPI CryptSetProviderExA (LPCSTR pszProvName, DWORD dwProvType, DWORD *pdwReserved, DWORD dwFlags)
{
	FIXME("(%s, %ld, %p, %08ld): stub!\n", pszProvName, dwProvType, pdwReserved, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptSetProviderExW (ADVAPI32.@)
 */
BOOL WINAPI CryptSetProviderExW (LPCWSTR pszProvName, DWORD dwProvType, DWORD *pdwReserved, DWORD dwFlags)
{
	FIXME("(%s, %ld, %p, %08ld): stub!\n", debugstr_w(pszProvName), dwProvType, pdwReserved, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptSetProvParam (ADVAPI32.@)
 */
BOOL WINAPI CryptSetProvParam (HCRYPTPROV hProv, DWORD dwParam, BYTE *pbData, DWORD dwFlags)
{
	FIXME("(0x%lx, %ld, %p, %08ld): stub!\n", hProv, dwParam, pbData, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptVerifySignatureA (ADVAPI32.@)
 */
BOOL WINAPI CryptVerifySignatureA (HCRYPTHASH hHash, BYTE *pbSignature, DWORD dwSigLen,
		HCRYPTKEY hPubKey, LPCSTR sDescription, DWORD dwFlags)
{
	FIXME("(0x%lx, %p, %ld, 0x%lx, %s, %08ld): stub!\n", hHash, pbSignature,
			dwSigLen, hPubKey, sDescription, dwFlags);
	return FALSE;
}

/******************************************************************************
 * CryptVerifySignatureW (ADVAPI32.@)
 */
BOOL WINAPI CryptVerifySignatureW (HCRYPTHASH hHash, BYTE *pbSignature, DWORD dwSigLen,
		HCRYPTKEY hPubKey, LPCWSTR sDescription, DWORD dwFlags)
{
	FIXME("(0x%lx, %p, %ld, 0x%lx, %s, %08ld): stub!\n", hHash, pbSignature,
			dwSigLen, hPubKey, debugstr_w(sDescription), dwFlags);
	return FALSE;
}
