/*
 * VARIANT test program
 *
 * Copyright 1998 Jean-Claude Cote
 *
 * The purpose of this program is validate the implementation
 * of the APIs related to VARIANTs. The validation is done
 * by comparing the results given by the Windows implementation
 * versus the Wine implementation.
 *
 * This program tests the creation/coercion/destruction of VARIANTs.
 *
 * The program does not currently test any API that takes
 * arguments of type: IDispatch, IUnknown, DECIMAL, CURRENCY.
 *
 * Since the purpose of this program is to compare the results
 * from Windows and Wine it is written so that with a simple
 * define it can be compiled either in Windows or Linux.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * NOTES
 *	 - The Variant structure in Windows has a non-named union. This means
 *	 the member of the union are accessible simply by doing pVariant->pfltVal.
 *	 With gcc it is not possible to have non-named union so it has been named
 *	 'u'.  So it's members are accessible using this name like so
 *	 pVariant->u.pfltVal.  So if this program is compiled in Windows
 *	 the references to 'u' will need to be take out of this file.
 *
 *	 - Also the printf is a little different so the format specifiers may
 *	 need to be tweaked if this file is compile in Windows.
 *	 Printf is also different in that it continues printing numbers
 *	 even after there is no more significative digits left to print.  These
 *	 number are garbage and in windows they are set to zero but not
 *	 on Linux.
 *
 *	 - The VarDateFromStr is not implemented yet.
 *
 *	 - The date and floating point format may not be the exact same format has the one in
 *	 windows depending on what the Internatinal setting are in windows.
 *
 */



#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>
#include <time.h>

#include "wine/test.h"
#include "winbase.h"
#include "winuser.h"
#include "wingdi.h"
#include "winnls.h"
#include "winerror.h"
#include "winnt.h"

#include "wtypes.h"
#include "oleauto.h"


#define MAX_BUFFER  1024

static char* WtoA( OLECHAR* p )
{
    static char buffer[MAX_BUFFER];
    DWORD len = WideCharToMultiByte( CP_ACP, 0, p, -1, buffer+1, sizeof(buffer)-3, NULL, NULL );
    buffer[0] = '\"';
    buffer[len] = '\"';
    buffer[len+1] = 0;
    return buffer;
}

static OLECHAR* AtoW( char* p )
{
    OLECHAR *buffer;
    DWORD len = MultiByteToWideChar( CP_ACP, 0, p, -1, NULL, 0 );
    buffer = malloc( len * sizeof(OLECHAR) );
    MultiByteToWideChar( CP_ACP, 0, p, -1, buffer, len );
    return buffer;
}

static const struct _vartypes {
    int ind;
    DWORD vcind1,vcind2,vcex1,vcex2;
} vartypes[] = {
    {0, 0, 0x80070057, 0, 0x80020008 },
    {1, 0, 0x80070057, 0, 0x80020008 },
    {2, 0, 0, 0, 0x80020005 },
    {3, 0, 0, 0, 0x80020005 },
    {4, 0, 0, 0, 0x80020005 },
    {5, 0, 0, 0, 0x80020005 },
    {6, 0, 0, 0, 0x80020005 },
    {7, 0, 0, 0, 0x80020005 },
    {77,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {78,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {79,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {80,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {81,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {82,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {83,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {84,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {85,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {86,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {87,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {88,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {89,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {90,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {91,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {92,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {93,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {94,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {95,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {96,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {97,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {98,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
    {99,0x80020008, 0x80070057, 0x80020008, 0x80020008 },
};

static const char *strfromr8[] = {
"1",
"-1",
"21",
"-21",
"321",
"-321",
"4321",
"-4321",
"54321",
"-54321",
"654321",
"-654321",
"7654321",
"-7654321",
"87654321",
"-87654321",
"987654321",
"-987654321",
"1987654321",
"-1987654321",
"21987654321",
"-21987654321",
"321987654321",
"-321987654321",
"4321987654321",
"-4321987654321",
"54321987654321",
"-54321987654321",
"654321987654321",
"-654321987654321",
"7.65432198765432e+15",
"-7.65432198765432e+15",
"8.76543219876543e+16",
"-8.76543219876543e+16",
"9.87654321987654e+17",
"-9.87654321987654e+17",
"1.98765432198765e+18",
"-1.98765432198765e+18",
"2.19876543219877e+19",
"-2.19876543219877e+19",
"1",
"0",
"-1",
"1.2",
"0.2",
"-1.2",
"1.23",
"0.23",
"-1.23",
"1.234",
"0.234",
"-1.234",
"1.2345",
"0.2345",
"-1.2345",
"1.23456",
"0.23456",
"-1.23456",
"1.234567",
"0.234567",
"-1.234567",
"1.2345678",
"0.2345678",
"-1.2345678",
"1.23456789",
"0.23456789",
"-1.23456789",
"1.234567891",
"0.234567891",
"-1.234567891",
"1.2345678912",
"0.2345678912",
"-1.2345678912",
"1.23456789123",
"0.23456789123",
"-1.23456789123",
"1.234567891234",
"0.234567891234",
"-1.234567891234",
"1.2345678912345",
"0.2345678912345",
"-1.2345678912345",
"1.23456789123456",
"0.23456789123456",
"-1.23456789123456",
"1.23456789123457",
"0.234567891234567",
"-1.23456789123457",
"1.23456789123457",
"0.234567891234568",
"-1.23456789123457",
"1.23456789123457",
"0.234567891234568",
"-1.23456789123457",
"1.23456789123457",
"0.234567891234568",
"-1.23456789123457",
"1.23456789123457",
"0.234567891234568",
"-1.23456789123457",
"2",
"-2",
"22.2",
"-22.2",
"322.23",
"-322.23",
"4322.234",
"-4322.234",
"54322.2345",
"-54322.2345",
"654322.23456",
"-654322.23456",
"7654322.234567",
"-7654322.234567",
"87654322.2345678",
"-87654322.2345678",
"987654322.234568",
"-987654322.234568",
"1987654322.23457",
"-1987654322.23457",
"21987654322.2346",
"-21987654322.2346",
"321987654322.235",
"-321987654322.235",
"4321987654322.23",
"-4321987654322.23",
"54321987654322.2",
"-54321987654322.2",
"654321987654322",
"-654321987654322",
"7.65432198765432e+15",
"-7.65432198765432e+15",
"8.76543219876543e+16",
"-8.76543219876543e+16",
"9.87654321987654e+17",
"-9.87654321987654e+17",
"1.98765432198765e+18",
"-1.98765432198765e+18",
"2.19876543219877e+19",
"-2.19876543219877e+19",
/* r4 tests */
"1",
"-1",
"21",
"-21",
"321",
"-321",
"4321",
"-4321",
"54321",
"-54321",
"654321",
"-654321",
"7654321",
"-7654321",
"8.765432e+07",
"-8.765432e+07",
"9.876543e+08",
"-9.876543e+08",
"1.987654e+09",
"-1.987654e+09",
"1",
"0",
"-1",
"1.2",
"0.2",
"-1.2",
"1.23",
"0.23",
"-1.23",
"1.234",
"0.234",
"-1.234",
"1.2345",
"0.2345001", /* FIXME: should be 0.2345 ? */
"-1.2345",
"1.23456",
"0.23456",
"-1.23456",
"1.234567",
"0.234567",
"-1.234567",
"1.234568",
"0.2345678",
"-1.234568",
"1.234568",
"0.2345679",
"-1.234568",
"1.234568",
"0.2345679",
"-1.234568",
"2",
"-2",
"22.2",
"-22.2",
"322.23",
"-322.23",
"4322.234",
"-4322.234",
"54322.23",
"-54322.23",
"654322.2", /* FIXME: should be 654322.3 */
"-654322.2",/* FIXME: should be -654322.3 */
"7654322",
"-7654322",
"8.765432e+07",
"-8.765432e+07",
"9.876543e+08",
"-9.876543e+08",
"1.987654e+09",
"-1.987654e+09",
};

static const struct _strret_date {
    DATE	retval;
    DWORD	error;
    BOOL	todo;
} strrets_DATE[] = {
{  -2.000000, 0x80020005 },
{  -2.000000, 0x80020005 },
{  -2.000000, 0x80020005 },
{  -2.000000, 0x80020005 },
{  -2.000000, 0x80020005 },
{  -2.000000, 0x80020005 },
{  0.000000, 0 },
{  0.034028, 0 },
{  0.003472, 0 },
{  0.035417, 0 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  0.035417, 0x80020005 },
{  35797.000000, 0 },
{  37623.000000, 0 },
{  37623.000000, 0 },
{  37623.000000, 0 },
{  37623.000000, 0x80020005 },
{  0.043090, 0 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  0.043090, 0x80020005 },
{  36161.000000, 0 },
{  65380.000000, 0 },
{  2.000000, 0 },
{  3.000000, 0 },
{  3.000000, 0x80020005 },
{  36475.000000, 0 },
{  36475.000000, 0 },
{  36475.000000, 0x80020005 },
{  36475.000000, 0x80020005 },
{  36485.466100, 0 },
{  36475.466100, 0 },
{  36475.966100, 0 },
{  36475.966100, 0x80020005 },
{  36475.000127, 0 },
{  36475.000127, 0x80020005 },
{  36475.466100, 0 },
{  36475.466100, 0x80020005 },
{  36475.465972, 0 },
{  36475.041667, 0 },
{  36475.000000, 0 },
{  36475.466100, 0 },
{  36477.000000, 0 },
{  36477.000000, 0x80020005 },
{  36477.000000, 0 },
{  36477.000000, 0x80020005 },
{  36477.000000, 0x80020005 },
{  36526.000000, 0 },
{  36526.000000, 0x80020005 },
{  36163.375000, 0 },
{  36161.458333, 0 },
{  36475.166667, 0 },
{  36475.166667, 0x80020005 },
{  36475.166667, 0x80020005 },
{  36475.166667, 0x80020005 },
{  36475.166667, 0x80020005 },
{  65380.000000, 0 },
{  65380.000000, 0x80020005 },
{  65380.000000, 0 },
{  36465.000000, 0 },
{  36465.000000, 0 },
{  36465.000000, 0x80020005 },
{  36465.000000, 0x80020005 },
{  36465.000000, 0x80020005 },
{  36465.000000, 0x80020005 },
{  36465.000000, 0x80020005 },
{  36465.000000, 0x80020005 },
{  36465.000000, 0x80020005 },
{  36465.000000, 0x80020005 },
{  36465.000000, 0x80020005 },
{  36465.000000, 0x80020005 },
{  0.045139, 0 },
{  0.086806, 0 },
{  0.128472, 0 },
{  0.170139, 0 },
{  0.170139, 0x80020005 },
{  0.170139, 0x80020005 },
{  0.170139, 0x80020005 },
{  0.170139, 0x80020005 },
{  0.170139, 0x80020005 },
{  0.170139, 0x80020005 },
};
static const struct _strret_b {
    BOOL retval;
    DWORD error;
} strrets_B[] = {
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_FALSE, 0 },
{  VARIANT_FALSE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_FALSE, 0 },
{  VARIANT_FALSE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_FALSE, 0 },
{  VARIANT_FALSE, 0x80020005 },
{  VARIANT_FALSE, 0x80020005 },
{  VARIANT_FALSE, 0x80020005 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
{  VARIANT_TRUE, 0x80020005 },
};
static const struct _strret_r8 {
    DOUBLE retval;
    DWORD error;
} strrets_R8[] = {
{  -2.000000, 0 },
{  -1.000000, 0 },
{  -0.510000, 0 },
{  -0.500000, 0 },
{  -0.490000, 0 },
{  0.000000, 0 },
{  0.000000, 0 },
{  0.490000, 0 },
{  0.500000, 0 },
{  0.510000, 0 },
{  1.000000, 0 },
{  127.000000, 0 },
{  128.000000, 0 },
{  129.000000, 0 },
{  255.000000, 0 },
{  256.000000, 0 },
{  257.000000, 0 },
{  32767.000000, 0 },
{  32768.000000, 0 },
{  -32768.000000, 0 },
{  -32769.000000, 0 },
{  16777216.000000, 0 },
{  16777217.000000, 0 },
{  -16777216.000000, 0 },
{  16777217.000000, 0 },
{  2147483647.000000, 0 },
{  2147483648.000000, 0 },
{  -2147483647.000000, 0 },
{  -2147483648.000000, 0 },
{  -2147483648.000000, 0x80020005 },
{  -2147483648.000000, 0x80020005 },
{  -2147483648.000000, 0x80020005 },
{  -2147483648.000000, 0x80020005 },
{  1.000000, 0 },
{  1.000000, 0x80020005 },
{  123.000000, 0 },
{  123.000000, 0x80020005 },
{  123.000000, 0x80020005 },
{  123.000000, 0x80020005 },
{  123.000000, 0x80020005 },
{  0.000000, 0 },
{  0.000000, 0 },
{  100000000000.000000, 0 },
{  24.000000, 0 },
{  32.000000, 0 },
{  32.000000, 0x80020005 },
{  200.000000, 0 },
{  200.000000, 0x80020005 },
{  200.000000, 0x80020005 },
{  200.000000, 0x80020005 },
{  1000000000000000100000000000000000000000000000000000000000000000.000000, 0 },
{  1.000000, 0 },
{  1.000000, 0 },
{  99999999999999997000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000.000000, 0 },
{  1.000000, 0 },
{  65535.000000, 0 },
{  65535.500000, 0 },
{  65536.000000, 0 },
{  4294967295.000000, 0 },
{  4294967296.000000, 0 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  1.500000, 0 },
{  2.500000, 0 },
{  3.500000, 0 },
{  4.500000, 0 },
{  4.500000, 0x80020005 },
{  4.500000, 0x80020005 },
{  4.500000, 0x80020005 },
{  4.500000, 0x80020005 },
{  4.500000, 0x80020005 },
{  4.500000, 0x80020005 },
};
static const struct _strret_r4 {
    FLOAT retval;
    DWORD error;
} strrets_R4[] = {
{  -2.000000, 0 },
{  -1.000000, 0 },
{  -0.510000, 0 },
{  -0.500000, 0 },
{  -0.490000, 0 },
{  0.000000, 0 },
{  0.000000, 0 },
{  0.490000, 0 },
{  0.500000, 0 },
{  0.510000, 0 },
{  1.000000, 0 },
{  127.000000, 0 },
{  128.000000, 0 },
{  129.000000, 0 },
{  255.000000, 0 },
{  256.000000, 0 },
{  257.000000, 0 },
{  32767.000000, 0 },
{  32768.000000, 0 },
{  -32768.000000, 0 },
{  -32769.000000, 0 },
{  16777216.000000, 0 },
{  16777216.000000, 0 },
{  -16777216.000000, 0 },
{  16777216.000000, 0 },
{  2147483648.000000, 0 },
{  2147483648.000000, 0 },
{  -2147483648.000000, 0 },
{  -2147483648.000000, 0 },
{  -2147483648.000000, 0x80020005 },
{  -2147483648.000000, 0x80020005 },
{  -2147483648.000000, 0x80020005 },
{  -2147483648.000000, 0x80020005 },
{  1.000000, 0 },
{  1.000000, 0x80020005 },
{  123.000000, 0 },
{  123.000000, 0x80020005 },
{  123.000000, 0x80020005 },
{  123.000000, 0x80020005 },
{  123.000000, 0x80020005 },
{  0.000000, 0 },
{  0.000000, 0 },
{  99999997952.000000, 0 },
{  24.000000, 0 },
{  32.000000, 0 },
{  32.000000, 0x80020005 },
{  200.000000, 0 },
{  200.000000, 0x80020005 },
{  200.000000, 0x80020005 },
{  200.000000, 0x80020005 },
{  200.000000, 0x8002000A },
{  1.000000, 0 },
{  1.000000, 0 },
{  1.000000, 0x8002000A },
{  1.000000, 0 },
{  65535.000000, 0 },
{  65535.500000, 0 },
{  65536.000000, 0 },
{  4294967296.000000, 0 },
{  4294967296.000000, 0 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  4294967296.000000, 0x80020005 },
{  1.500000, 0 },
{  2.500000, 0 },
{  3.500000, 0 },
{  4.500000, 0 },
{  4.500000, 0x80020005 },
{  4.500000, 0x80020005 },
{  4.500000, 0x80020005 },
{  4.500000, 0x80020005 },
{  4.500000, 0x80020005 },
{  4.500000, 0x80020005 },
};
static const struct _strret_i4 {
    LONG retval;
    DWORD error;
} strrets_I4[] = {
{  -2, 0 },
{  -1, 0 },
{  -1, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  1, 0 },
{  1, 0 },
{  127, 0 },
{  128, 0 },
{  129, 0 },
{  255, 0 },
{  256, 0 },
{  257, 0 },
{  32767, 0 },
{  32768, 0 },
{  -32768, 0 },
{  -32769, 0 },
{  16777216, 0 },
{  16777217, 0 },
{  -16777216, 0 },
{  16777217, 0 },
{  2147483647, 0 },
{  2147483647, 0x8002000A },
{  -2147483647, 0 },
{  -2147483648, 0 },
{  -2147483648, 0x80020005 },
{  -2147483648, 0x80020005 },
{  -2147483648, 0x80020005 },
{  -2147483648, 0x80020005 },
{  1, 0 },
{  1, 0x80020005 },
{  123, 0 },
{  123, 0x80020005 },
{  123, 0x80020005 },
{  123, 0x80020005 },
{  123, 0x80020005 },
{  0, 0 },
{  0, 0 },
{  0, 0x8002000A },
{  24, 0 },
{  32, 0 },
{  32, 0x80020005 },
{  200, 0 },
{  200, 0x80020005 },
{  200, 0x80020005 },
{  200, 0x80020005 },
{  200, 0x8002000A },
{  1, 0 },
{  1, 0 },
{  1, 0x8002000A },
{  1, 0 },
{  65535, 0 },
{  65536, 0 },
{  65536, 0 },
{  65536, 0x8002000A },
{  65536, 0x8002000A },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  65536, 0x80020005 },
{  2, 0 },
{  2, 0 },
{  4, 0 },
{  4, 0 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
};
static const struct _strret_i2 {
    SHORT retval;
    DWORD error;
} strrets_I2[] = {
{  -2, 0 },
{  -1, 0 },
{  -1, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  1, 0 },
{  1, 0 },
{  127, 0 },
{  128, 0 },
{  129, 0 },
{  255, 0 },
{  256, 0 },
{  257, 0 },
{  32767, 0 },
{  32767, 0x8002000A },
{  -32768, 0 },
{  -32768, 0x8002000A },
{  -32768, 0x8002000A },
{  -32768, 0x8002000A },
{  -32768, 0x8002000A },
{  -32768, 0x8002000A },
{  -32768, 0x8002000A },
{  -32768, 0x8002000A },
{  -32768, 0x8002000A },
{  -32768, 0x8002000A },
{  -32768, 0x80020005 },
{  -32768, 0x80020005 },
{  -32768, 0x80020005 },
{  -32768, 0x80020005 },
{  1, 0 },
{  1, 0x80020005 },
{  123, 0 },
{  123, 0x80020005 },
{  123, 0x80020005 },
{  123, 0x80020005 },
{  123, 0x80020005 },
{  0, 0 },
{  0, 0 },
{  0, 0x8002000A },
{  24, 0 },
{  32, 0 },
{  32, 0x80020005 },
{  200, 0 },
{  200, 0x80020005 },
{  200, 0x80020005 },
{  200, 0x80020005 },
{  200, 0x8002000A },
{  1, 0 },
{  1, 0 },
{  1, 0x8002000A },
{  1, 0 },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  2, 0 },
{  2, 0 },
{  4, 0 },
{  4, 0 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
};
static const struct _strret_i1 {
    CHAR retval;
    DWORD error;
} strrets_I1[] = {
{  -2, 0 },
{  -1, 0 },
{  -1, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  1, 0 },
{  1, 0 },
{  127, 0 },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x8002000A },
{  127, 0x80020005 },
{  127, 0x80020005 },
{  127, 0x80020005 },
{  127, 0x80020005 },
{  1, 0 },
{  1, 0x80020005 },
{  123, 0 },
{  123, 0x80020005 },
{  123, 0x80020005 },
{  123, 0x80020005 },
{  123, 0x80020005 },
{  0, 0 },
{  0, 0 },
{  0, 0x8002000A },
{  24, 0 },
{  32, 0 },
{  32, 0x80020005 },
{  32, 0x8002000A },
{  32, 0x80020005 },
{  32, 0x80020005 },
{  32, 0x80020005 },
{  32, 0x8002000A },
{  1, 0 },
{  1, 0 },
{  1, 0x8002000A },
{  1, 0 },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  2, 0 },
{  2, 0 },
{  4, 0 },
{  4, 0 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
};
static const struct _strret_u1 {
    BYTE retval;
    DWORD error;
} strrets_U1[] = {
{  0, 0x8002000A },
{  0, 0x8002000A },
{  0, 0x8002000A },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  0, 0 },
{  1, 0 },
{  1, 0 },
{  0x7F, 0 },
{  0x80, 0 },
{  0x81, 0 },
{  0xFF, 0 },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x8002000A },
{  0xFF, 0x80020005 },
{  0xFF, 0x80020005 },
{  0xFF, 0x80020005 },
{  0xFF, 0x80020005 },
{  1, 0 },
{  1, 0x80020005 },
{  0x7B, 0 },
{  0x7B, 0x80020005 },
{  0x7B, 0x80020005 },
{  0x7B, 0x80020005 },
{  0x7B, 0x80020005 },
{  0, 0 },
{  0, 0 },
{  0, 0x8002000A },
{  0x18, 0 },
{  0x20, 0 },
{  0x20, 0x80020005 },
{  0xC8, 0 },
{  0xC8, 0x80020005 },
{  0xC8, 0x80020005 },
{  0xC8, 0x80020005 },
{  0xC8, 0x8002000A },
{  1, 0 },
{  1, 0 },
{  1, 0x8002000A },
{  1, 0 },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x8002000A },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  1, 0x80020005 },
{  2, 0 },
{  2, 0 },
{  4, 0 },
{  4, 0 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
{  4, 0x80020005 },
};

static const struct _strret_U2 {
    WORD retval;
    DWORD error;
} strrets_U2[] = {
	{  0, 0x8002000A },
	{  0, 0x8002000A },
	{  0, 0x8002000A },
	{  0, 0 },
	{  0, 0 },
	{  0, 0 },
	{  0, 0 },
	{  0, 0 },
	{  0, 0 },
	{  1, 0 },
	{  1, 0 },
	{  127, 0 },
	{  128, 0 },
	{  129, 0 },
	{  255, 0 },
	{  256, 0 },
	{  257, 0 },
	{  32767, 0 },
	{  32768, 0 },
	{  32768, 0x8002000A },
	{  32768, 0x8002000A },
	{  32768, 0x8002000A },
	{  32768, 0x8002000A },
	{  32768, 0x8002000A },
	{  32768, 0x8002000A },
	{  32768, 0x8002000A },
	{  32768, 0x8002000A },
	{  32768, 0x8002000A },
	{  32768, 0x8002000A },
	{  32768, 0x80020005 },
	{  32768, 0x80020005 },
	{  32768, 0x80020005 },
	{  32768, 0x80020005 },
	{  1, 0 },
	{  1, 0x80020005 },
	{  123, 0 },
	{  123, 0x80020005 },
	{  123, 0x80020005 },
	{  123, 0x80020005 },
	{  123, 0x80020005 },
	{  0, 0 },
	{  0, 0 },
	{  0, 0x8002000A },
	{  24, 0 },
	{  32, 0 },
	{  32, 0x80020005 },
	{  200, 0 },
	{  200, 0x80020005 },
	{  200, 0x80020005 },
	{  200, 0x80020005 },
	{  200, 0x8002000A },
	{  1, 0 },
	{  1, 0 },
	{  1, 0x8002000A },
	{  1, 0 },
	{  65535, 0 },
	{  65535, 0x8002000A },
	{  65535, 0x8002000A },
	{  65535, 0x8002000A },
	{  65535, 0x8002000A },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  65535, 0x80020005 },
	{  2, 0 },
	{  2, 0 },
	{  4, 0 },
	{  4, 0 },
	{  4, 0x80020005 },
	{  4, 0x80020005 },
	{  4, 0x80020005 },
	{  4, 0x80020005 },
	{  4, 0x80020005 },
	{  4, 0x80020005 },
};

static const struct _strret_U4 {
    DWORD retval;
    DWORD error;
} strrets_U4[] = {
	{  0, 0x8002000A },
	{  0, 0x8002000A },
	{  0, 0x8002000A },
	{  0, 0 },
	{  0, 0 },
	{  0, 0 },
	{  0, 0 },
	{  0, 0 },
	{  0, 0 },
	{  1, 0 },
	{  1, 0 },
	{  127, 0 },
	{  128, 0 },
	{  129, 0 },
	{  255, 0 },
	{  256, 0 },
	{  257, 0 },
	{  32767, 0 },
	{  32768, 0 },
	{  32768, 0x8002000A },
	{  32768, 0x8002000A },
	{  16777216, 0 },
	{  16777217, 0 },
	{  16777217, 0x8002000A },
	{  16777217, 0 },
	{  2147483647, 0 },
	{  2147483648U, 0 },
	{  2147483648U, 0x8002000A },
	{  2147483648U, 0x8002000A },
	{  2147483648U, 0x80020005 },
	{  2147483648U, 0x80020005 },
	{  2147483648U, 0x80020005 },
	{  2147483648U, 0x80020005 },
	{  1, 0 },
	{  1, 0x80020005 },
	{  123, 0 },
	{  123, 0x80020005 },
	{  123, 0x80020005 },
	{  123, 0x80020005 },
	{  123, 0x80020005 },
	{  0, 0 },
	{  0, 0 },
	{  0, 0x8002000A },
	{  24, 0 },
	{  32, 0 },
	{  32, 0x80020005 },
	{  200, 0 },
	{  200, 0x80020005 },
	{  200, 0x80020005 },
	{  200, 0x80020005 },
	{  200, 0x8002000A },
	{  1, 0 },
	{  1, 0 },
	{  1, 0x8002000A },
	{  1, 0 },
	{  65535, 0 },
	{  65536, 0 },
	{  65536, 0 },
	{  4294967295U, 0 },
	{  4294967295U, 0x8002000A },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  4294967295U, 0x80020005 },
	{  2, 0 },
	{  2, 0 },
	{  4, 0 },
	{  4, 0 },
	{  4, 0x80020005 },
	{  4, 0x80020005 },
	{  4, 0x80020005 },
	{  4, 0x80020005 },
	{  4, 0x80020005 },
	{  4, 0x80020005 },
};

START_TEST(vartest)
{
	VARIANTARG va;
	VARIANTARG vb;
	VARIANTARG vc;
	VARIANTARG vd;
	VARIANTARG ve;

	int theInt = 0;
	int* pInt = &theInt;
	VARIANT_BOOL b = 0;
	VARIANT_BOOL* pBool = &b;
	unsigned short uShort = 0;
	unsigned short* pUShort = &uShort;
	unsigned long uLong = 0;
	unsigned long* pULong = &uLong;
	CHAR theChar;
	CHAR* pChar = &theChar;
	BYTE byte;
	BYTE* pByte = &byte;
	short s = 0;
	short* pShort = &s;
	long Long = 0;
	long* pLong = &Long;
	float f = 0;
	float* pFloat = &f;
	double d = 0;
	double* pDouble = &d;

	BSTR bstr = NULL;
	int off, i = 0;
	int nOlePtrs = 120;
	OLECHAR* pOleChar[120];
	char msg[200];

	pOleChar[0] = AtoW( "-2" );
	pOleChar[1] = AtoW( "-1" );
	pOleChar[2] = AtoW( "-0.51" );
	pOleChar[3] = AtoW( "-0.5" );
	pOleChar[4] = AtoW( "-0.49" );
	pOleChar[5] = AtoW( "-0.0" );
	pOleChar[6] = AtoW( "0.0" );
	pOleChar[7] = AtoW( "0.49" );
	pOleChar[8] = AtoW( "0.5" );
	pOleChar[9] = AtoW( "0.51" );
	pOleChar[10] = AtoW( "1" );
	pOleChar[11] = AtoW( "127" );
	pOleChar[12] = AtoW( "128" );
	pOleChar[13] = AtoW( "129" );
	pOleChar[14] = AtoW( "255" );
	pOleChar[15] = AtoW( "256" );
	pOleChar[16] = AtoW( "257" );
	pOleChar[17] = AtoW( "32767" );
	pOleChar[18] = AtoW( "32768" );
	pOleChar[19] = AtoW( "-32768" );
	pOleChar[20] = AtoW( "-32769" );
	pOleChar[21] = AtoW( "16777216" );
	pOleChar[22] = AtoW( "16777217" );
	pOleChar[23] = AtoW( "-16777216" );
	pOleChar[24] = AtoW( "16777217" );
	pOleChar[25] = AtoW( "2147483647" );
	pOleChar[26] = AtoW( "2147483648" );
	pOleChar[27] = AtoW( "-2147483647" );
	pOleChar[28] = AtoW( "-2147483648" );

	pOleChar[29] = AtoW( "" );
	pOleChar[30] = AtoW( " " );
	pOleChar[31] = AtoW( "1F" );
	pOleChar[32] = AtoW( "1G" );
	pOleChar[33] = AtoW( " 1 " );
	pOleChar[34] = AtoW( " 1 2 " );
	pOleChar[35] = AtoW( "1,2,3" );
	pOleChar[36] = AtoW( "1 2 3" );
	pOleChar[37] = AtoW( "1,2, 3" );
	pOleChar[38] = AtoW( "1;2;3" );
	pOleChar[39] = AtoW( "1.2.3" );

	pOleChar[40] = AtoW( "0." );
	pOleChar[41] = AtoW( ".0" );
	pOleChar[42] = AtoW( "0.1E12" );
	pOleChar[43] = AtoW( "2.4,E1" );
	pOleChar[44] = AtoW( "	+3.2,E1" );
	pOleChar[45] = AtoW( "4E2.5" );
	pOleChar[46] = AtoW( "	2E+2" );
	pOleChar[47] = AtoW( "1 E+2" );
	pOleChar[48] = AtoW( "." );
	pOleChar[49] = AtoW( ".E2" );
	pOleChar[50] = AtoW( "1000000000000000000000000000000000000000000000000000000000000000" );
	pOleChar[51] = AtoW( "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001" );
	pOleChar[52] = AtoW( "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001" );
	pOleChar[53] = AtoW( "100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001" );
	pOleChar[54] = AtoW( "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001" );
	pOleChar[55] = AtoW( "65535" );
	pOleChar[56] = AtoW( "65535.5" );
	pOleChar[57] = AtoW( "65536" );
	pOleChar[58] = AtoW( "4294967295" );
	pOleChar[59] = AtoW( "4294967296" );

	pOleChar[60] = AtoW( "1 January 99" );
	pOleChar[61] = AtoW( "December 31, 2078" );
	pOleChar[62] = AtoW( "January 1, 1900" );
	pOleChar[63] = AtoW( "January 2 1900" );
	pOleChar[64] = AtoW( "11.11.1999" );
	pOleChar[65] = AtoW( "11/11/1999" );
	pOleChar[66] = AtoW( " 11 / 11 / 1999" );
	pOleChar[67] = AtoW( "11/11/1999:11:11:1134" );
	pOleChar[68] = AtoW( "11/11/1999 11:11:11:1" );
	pOleChar[69] = AtoW( "\t1999/\t11/21 11 :11:11am" );

	pOleChar[70] = AtoW( "11/11/1999 11:11:11Am" );
	pOleChar[71] = AtoW( "11/11/1999 11:11:11PM" );
	pOleChar[72] = AtoW( "11/11/199911:11:11PM" );
	pOleChar[73] = AtoW( "11/11/1999 0:0:11am" );
	pOleChar[74] = AtoW( "11/11/1999 11,11:11am" );
	pOleChar[75] = AtoW( "11/11/1999 11:11:11am" );
	pOleChar[76] = AtoW( "11/11/1999 11/11:11am" );
	pOleChar[77] = AtoW( "11/11/1999 11:11AM" );
	pOleChar[78] = AtoW( "11/11/1999 1AM" );
	pOleChar[79] = AtoW( "11/11/1999 0AM" );

	pOleChar[80] = AtoW( "11/11/1999 11:11:11" );
	pOleChar[81] = AtoW( "11/13/1999 0AM" );
	pOleChar[82] = AtoW( "13/13/1999 0AM" );
	pOleChar[83] = AtoW( "13/11/1999 0AM" );
	pOleChar[84] = AtoW( "11/33/1999 0AM" );
	pOleChar[85] = AtoW( "11/11/1999 AM" );
	pOleChar[86] = AtoW( "1/1/0 0AM" );
	pOleChar[87] = AtoW( "1/1/-1 0AM" );
	pOleChar[88] = AtoW( "1999 January 3 9AM" );
	pOleChar[89] = AtoW( "1 January 1999 11AM" );

	pOleChar[90] = AtoW( "4AM 11/11/1999" );
	pOleChar[91] = AtoW( "4:22 11/11/1999 AM" );
	pOleChar[92] = AtoW( " 1 1 /11/1999" );
	pOleChar[93] = AtoW( "11-11/1999 11:11:11.12AM" );
	pOleChar[94] = AtoW( "1999 January 3, 9AM" );
	pOleChar[95] = AtoW( "December, 31, 2078" );
	pOleChar[96] = AtoW( "December, 31, 2078," );
	pOleChar[97] = AtoW( "December, 31 2078" );
	pOleChar[98] = AtoW( "11/99" );
	pOleChar[99] = AtoW( "11-1999" );

	pOleChar[100] = AtoW( "true" );
	pOleChar[101] = AtoW( "True" );
	pOleChar[102] = AtoW( "TRue" );
	pOleChar[103] = AtoW( "TRUE" );
	pOleChar[104] = AtoW( " TRUE" );
	pOleChar[105] = AtoW( "FALSE " );
	pOleChar[106] = AtoW( "False" );
	pOleChar[107] = AtoW( "JustSomeText" );
	pOleChar[108] = AtoW( "Just Some Text" );
	pOleChar[109] = AtoW( "" );

	pOleChar[110] = AtoW( "1.5" );
	pOleChar[111] = AtoW( "2.5" );
	pOleChar[112] = AtoW( "3.5" );
	pOleChar[113] = AtoW( "4.5" );
	pOleChar[114] = AtoW( "" );
	pOleChar[115] = AtoW( "" );
	pOleChar[116] = AtoW( "" );
	pOleChar[117] = AtoW( "" );
	pOleChar[118] = AtoW( "" );
	pOleChar[119] = AtoW( "" );


	/* Start testing the Low-Level API ( the coercions )
	 */


	/* unsigned char from...
	 */
	trace( "\n\n======== Testing VarUI1FromXXX ========\n");

#define XOK "should return S_OK"
#define XOV "should return DISP_E_OVERFLOW"
	/* ok(S_OK == VarUI1FromI2( 0, NULL ), XOK);
	 */
	trace( "VarUI1FromI2: passing in NULL as return val makes it crash, need to write proper test.\n" );

	ok(VarUI1FromStr(NULL,0,0,pByte) == DISP_E_TYPEMISMATCH,"should return DISP_E_TYPEMISMATCH");
	ok(S_OK == VarUI1FromI2( 0, pByte ), XOK);
	ok(*pByte == 0,"should give 0 byte value");

	ok(S_OK == VarUI1FromI2( 69, pByte ), XOK);
	ok(*pByte == 69,"should give 69 byte value");

	ok(S_OK == VarUI1FromI2( 70, pByte ), XOK);
	ok(*pByte == 70,"should give 70 byte value");

	ok(S_OK == VarUI1FromI2( 128, pByte ), XOK);
	ok(*pByte == 128,"should give 128 byte value");

	ok(S_OK == VarUI1FromI2( 255, pByte ), XOK);
	ok(*pByte == 255,"should give 255 byte value");

	ok(DISP_E_OVERFLOW == VarUI1FromI2( 256, pByte ), XOV);
	ok(DISP_E_OVERFLOW == VarUI1FromI2( 257, pByte ), XOV);

	ok(S_OK == VarUI1FromR8( 0.0, pByte ), XOK);
	ok(*pByte == 0,"0.0 float should be converted to 0");

	ok(S_OK == VarUI1FromR8( 69.33, pByte ), XOK);
	ok(*pByte == 0x45, "expected 69 (hex 0x45) as byte value");

	ok(S_OK == VarUI1FromR8( 69.66, pByte ), XOK);
	ok(*pByte == 0x46, "expected 70 (hex 0x46) as byte value");

	ok(DISP_E_OVERFLOW == VarUI1FromR8( -69.33, pByte ), XOV);
	ok(DISP_E_OVERFLOW == VarUI1FromR8( -69.66, pByte ), XOV);

	ok(S_OK == VarUI1FromR8( -0.5, pByte ), XOK);
	ok(*pByte == 0,"-0.5 should give return 0");

	ok(DISP_E_OVERFLOW == VarUI1FromR8( -0.51, pByte ), XOV);

	ok(S_OK == VarUI1FromR8( -0.49, pByte ), XOK);
	ok(*pByte == 0,"-0.49 should give return 0");

	ok(S_OK == VarUI1FromR8( 0.5, pByte ), XOK);
	ok(*pByte == 0,"0.5 should give return 0");

	ok(S_OK == VarUI1FromR8( 0.51, pByte ), XOK);
	ok(*pByte == 1,"0.51 should give return 1");

	ok(S_OK == VarUI1FromR8( 0.49, pByte ), XOK);
	ok(*pByte == 0,"0.49 should give return 0");

	ok(S_OK == VarUI1FromDate( 0.0, pByte ), XOK);
	ok(*pByte == 0,"0.0 date should give return 0");

	ok(S_OK == VarUI1FromDate( 69.33, pByte ), XOK);
	ok(*pByte == 0x45,"69.33 date should give return 0x45");

	ok(S_OK == VarUI1FromDate( 69.66, pByte ), XOK);
	ok(*pByte == 0x46,"69.66 date should give return 0x46");

	ok(DISP_E_OVERFLOW == VarUI1FromDate( -69.33, pByte ), XOV);

	ok(DISP_E_OVERFLOW == VarUI1FromDate( -69.66, pByte ), XOV);

	ok(S_OK == VarUI1FromBool( VARIANT_TRUE, pByte ), XOK);
	ok(*pByte == 0xff, "true should be converted to 0xff");

	ok(S_OK == VarUI1FromBool( VARIANT_FALSE, pByte ), XOK);
	ok(*pByte == 0, "false should be converted to 0");

	for( i = 0; i < nOlePtrs; i ++ )
	{
	        char msg[200];

		sprintf(msg,"offset %d was expecting return code %lx\n",i,strrets_U1[i].error);
		ok(strrets_U1[i].error == VarUI1FromStr( pOleChar[i], 0, 0, pByte ), msg);
		sprintf(msg,"offset %d was expecting return value %02x\n",i,strrets_U1[i].retval);
		ok(strrets_U1[i].retval == *pByte,msg);
	}

	/* unsigned short from ... */
	trace( "\n\n======== Testing VarUI2FromXXX ========\n");

	ok(DISP_E_OVERFLOW == VarUI2FromI2( -1, pUShort ), XOV);
	/* ok(S_OK == VarUI2FromI2( 0, NULL ), XOK);
	 */
	trace("VarUI2FromI2: passing in NULL as return val makes it crash, needs to be fixed.\n");

	ok(DISP_E_TYPEMISMATCH == VarUI2FromStr( NULL, 0, 0, pUShort ), "should return DISP_E_TYPEMISMATCH");

	ok(S_OK == VarUI2FromI2( 0, pUShort ), XOK);
	ok(*pUShort == 0,"0 should be 0");
	ok(S_OK == VarUI2FromI2( 69, pUShort ), XOK);
	ok(*pUShort == 69,"69 should be 69");
	ok(S_OK == VarUI2FromI2( 70, pUShort ), XOK);
	ok(*pUShort == 70,"70 should be 70");

	ok(S_OK == VarUI2FromI2( 128, pUShort ), XOK);
	ok(*pUShort == 128,"128 should be 128");

	ok(S_OK == VarUI2FromI4( 65535, pUShort ), XOK);
	ok(*pUShort == 65535,"65535 should be 65535");
	ok(DISP_E_OVERFLOW == VarUI2FromI4( 65536, pUShort ), XOV);
	ok(DISP_E_OVERFLOW == VarUI2FromI4( 65537, pUShort ), XOV);
	ok(S_OK == VarUI2FromR8( 0.0, pUShort ), XOK);
	ok(*pUShort == 0,"0.0 should be 0");
	ok(S_OK == VarUI2FromR8( 69.33, pUShort ), XOK);
	ok(*pUShort == 69,"69.33 should be 69");
	ok(S_OK == VarUI2FromR8( 69.66, pUShort ), XOK);
	ok(*pUShort == 70,"69.66 should be 70");

	ok(DISP_E_OVERFLOW == VarUI2FromR8( -69.33, pUShort ), XOV);
	ok(DISP_E_OVERFLOW == VarUI2FromR8( -69.66, pUShort ), XOV);

	ok(S_OK == VarUI2FromR8( -0.5, pUShort ), XOK);
	ok(*pUShort == 0, "-0.5 -> 0");
	ok(DISP_E_OVERFLOW == VarUI2FromR8( -0.51, pUShort ), XOV);
	ok(S_OK == VarUI2FromR8( -0.49, pUShort ), XOK);
	ok(*pUShort == 0, "-0.49 -> 0");

	ok(S_OK == VarUI2FromR8( 0.5, pUShort ), XOK);
	ok(*pUShort == 0,"0.5 should be 0");
	ok(S_OK == VarUI2FromR8( 0.51, pUShort ), XOK);
	ok(*pUShort == 1,"0.51 should be 1");
	ok(S_OK == VarUI2FromR8( 0.49, pUShort ), XOK);
	ok(*pUShort == 0,"0.49 should be 0");

	ok(S_OK == VarUI2FromDate( 0.0, pUShort ), XOK);
	ok(*pUShort == 0,"0.0 should be 0");
	ok(S_OK == VarUI2FromDate( 69.33, pUShort ), XOK);
	ok(*pUShort == 69,"69.33 should be 69");
	ok(S_OK == VarUI2FromDate( 69.66, pUShort ), XOK);
	ok(*pUShort == 70,"69.66 should be 70");
	ok(DISP_E_OVERFLOW == VarUI2FromDate( -69.33, pUShort ), XOV);
	ok(DISP_E_OVERFLOW == VarUI2FromDate( -69.66, pUShort ), XOV);

	ok(S_OK == VarUI2FromBool( VARIANT_TRUE, pUShort ), XOK);
	ok(*pUShort == 65535,"TRUE should be 65535");
	ok(S_OK == VarUI2FromBool( VARIANT_FALSE, pUShort ), XOK);
	ok(*pUShort == 0,"FALSE should be 0");

	for( i = 0; i < nOlePtrs; i ++ )
	{
		char msg[200];

		sprintf(msg,"offset %d, expecting error 0x%lx\n",i,strrets_U2[i].error);
		ok(strrets_U2[i].error == VarUI2FromStr( pOleChar[i], 0, 0, pUShort ), msg);
		sprintf(msg,"offset %d, expecting retval 0x%x\n",i,strrets_U2[i].retval);
		ok(strrets_U2[i].retval == *pUShort, msg);
	}

	/* unsigned long from ...
	 */
	trace( "\n\n======== Testing VarUI4FromXXX ========\n");
	/*ok(S_OK == VarUI4FromI2( 0, NULL ), XOK);
	 */
	trace( "VarUI4FromI2: passing in NULL as return val makes it crash, implement me.\n");

	ok(DISP_E_TYPEMISMATCH == VarUI4FromStr( NULL, 0, 0, pULong ), "should erturn DISP_E_TYPEMISMATCH");

	ok(S_OK == VarUI4FromI2( 0, pULong ), XOK);
	ok(*pULong == 0,"0 should be 0");
	ok(S_OK == VarUI4FromI2( 69, pULong ), XOK);
	ok(*pULong == 69,"69 should be 69");

	ok(S_OK == VarUI4FromI2( 70, pULong ), XOK);
	ok(*pULong == 70,"70 should be 70");

	ok(S_OK == VarUI4FromI2( 128, pULong ), XOK);
	ok(*pULong == 128,"128 should be 128");
	ok(S_OK == VarUI4FromI2( 255, pULong ), XOK);
	ok(*pULong == 255,"255 should be 255");

	ok(S_OK == VarUI4FromR8( 4294967295.0, pULong ), XOK);
	ok(*pULong == 4294967295U,"4294967295.0 should be 4294967295");
	ok(DISP_E_OVERFLOW == VarUI4FromR8( 4294967296.0, pULong ), XOV);

	ok(S_OK == VarUI4FromR8( 0.0, pULong ), XOK);
	ok(*pULong == 0,"0 should be 0");
	ok(S_OK == VarUI4FromR8( 69.33, pULong ), XOK);
	ok(*pULong == 69,"69.33 should be 69");
	ok(S_OK == VarUI4FromR8( 69.66, pULong ), XOK);
	ok(*pULong == 70,"69.66 should be 70");
	ok(DISP_E_OVERFLOW == VarUI4FromR8( -69.33, pULong ), XOV);
	ok(DISP_E_OVERFLOW == VarUI4FromR8( -69.66, pULong ), XOV);

	ok(S_OK == VarUI4FromR8( -0.5, pULong ), XOK);
	ok(*pULong == 0,"-0.5 should be 0");

	ok(DISP_E_OVERFLOW == VarUI4FromR8( -0.51, pULong ), XOV);

	ok(S_OK == VarUI4FromR8( -0.49, pULong ), XOK);
	ok(*pULong == 0,"-0.49 should be 0");

	ok(S_OK == VarUI4FromR8( 0.5, pULong ), XOK);
	ok(*pULong == 0,"0.5 should be 0");
	ok(S_OK == VarUI4FromR8( 0.51, pULong ), XOK);
	ok(*pULong == 1,"0.51 should be 1");
	ok(S_OK == VarUI4FromR8( 0.49, pULong ), XOK);
	ok(*pULong == 0,"0.49 should be 0");

	ok(S_OK == VarUI4FromDate( 0.0, pULong ), XOK);
	ok(*pULong == 0,"0.0 should be 0");
	ok(S_OK == VarUI4FromDate( 69.33, pULong ), XOK);
	ok(*pULong == 69,"69.33 should be 69");
	ok(S_OK == VarUI4FromDate( 69.66, pULong ), XOK);
	ok(*pULong == 70,"69.66 should be 70");
	ok(DISP_E_OVERFLOW == VarUI4FromDate( -69.33, pULong ), XOV);
	ok(DISP_E_OVERFLOW == VarUI4FromDate( -69.66, pULong ), XOV);

	ok(S_OK == VarUI4FromBool( VARIANT_TRUE, pULong ), XOK);
	ok(*pULong == 4294967295U, "TRUE should be 4294967295");
	ok(S_OK == VarUI4FromBool( VARIANT_FALSE, pULong ), XOK);
	ok(*pULong == 0, "FALSE should be 0");

	for( i = 0; i < nOlePtrs; i ++ )
	{
	    	char msg[200];

		sprintf(msg,"offset %d should return 0x%lx\n",i,
			strrets_U4[i].error);
		ok(strrets_U4[i].error == VarUI4FromStr( pOleChar[i], 0, 0, pULong ), msg);
		sprintf(msg,"offset %d should have retval 0x%lx\n",i,
			strrets_U4[i].retval);
		ok(*pULong == strrets_U4[i].retval,msg);
	}

	/* CHAR from ...
	 */
	trace( "\n\n======== Testing VarI1FromXXX ========\n");

	ok(S_OK == VarI1FromBool( VARIANT_TRUE, pByte ), XOK);
	ok(*pByte == 255, " TRUE should be 255");

	ok(S_OK == VarI1FromBool( VARIANT_TRUE, pChar ), XOK);
	ok(*pChar == -1, "TRUE should be -1");

	ok(S_OK == VarI1FromBool( VARIANT_FALSE, pChar ), XOK);
	ok(*pChar == 0, "FALSE should be 0");

	ok(DISP_E_OVERFLOW == VarI1FromUI1( (unsigned char)32767, pChar ), XOV);
	ok(*pChar == 0, "should still be 0");
	ok(DISP_E_OVERFLOW == VarI1FromUI1( (unsigned char)65535, pChar ), XOV);
	ok(*pChar == 0, "should still be 0");

	ok(DISP_E_OVERFLOW == VarI1FromI4( 32767, pChar ), XOV);
	ok(*pChar == 0, "should still be 0");
	ok(DISP_E_OVERFLOW == VarI1FromI4( 32768, pChar ), XOV);
	ok(*pChar == 0, "should still be 0");
	ok(DISP_E_OVERFLOW == VarI1FromI4( -32768, pChar ), XOV);
	ok(*pChar == 0, "should still be 0");
	ok(DISP_E_OVERFLOW == VarI1FromI4( -32769, pChar ), XOV);
	ok(*pChar == 0, "should still be 0");

	ok(S_OK == VarI1FromR8( 69.33, pChar ), XOK);
	ok(*pChar == 69, "69.33 should be 69");
	ok(S_OK == VarI1FromR8( 69.66, pChar ), XOK);
	ok(*pChar == 70, "69.66 should be 70");

	ok(S_OK == VarI1FromR8( -69.33, pChar ), XOK);
	ok(*pChar == -69, "-69.33 should be -69");
	ok(S_OK == VarI1FromR8( -69.66, pChar ), XOK);
	ok(*pChar == -70, "-69.66 should be -70");
	ok(S_OK == VarI1FromDate( -69.66, pChar ), XOK);
	ok(*pChar == -70, "-69.66 should be -70");

	for( i = 0; i < nOlePtrs; i ++ )
	{
	    	char msg[200];

		sprintf(msg,"offset %d should return 0x%lx\n",i,strrets_I1[i].error);
		ok(strrets_I1[i].error == VarI1FromStr( pOleChar[i], 0, 0, pChar ), msg);
		sprintf(msg,"offset %d should have retval %d\n",i,strrets_I1[i].retval);
		ok(strrets_I1[i].retval == *pChar, msg);
	}

	/* short from ...
	 */
	trace( "\n\n======== Testing VarI2FromXXX ========\n");

	ok(S_OK == VarI2FromUI2( 32767, pShort ), XOK);
	ok(*pShort == 32767, "should be 32767");
	ok(DISP_E_OVERFLOW == VarI2FromUI2( 65535, pShort ), XOV);
	ok(*pShort == 32767, "pShort should be unchanged");

	ok(S_OK == VarI2FromI4( 32767, pShort ), XOK);
	ok(*pShort == 32767, "should be 32767");
	ok(DISP_E_OVERFLOW == VarI2FromI4( 32768, pShort ), XOV);
	ok(*pShort == 32767, "should still be 32767");
	ok(S_OK == VarI2FromI4( -32768, pShort ), XOK);
	ok(*pShort == -32768, "should be -32768");
	ok(DISP_E_OVERFLOW == VarI2FromI4( -32769, pShort ), XOV);
	ok(*pShort == -32768, "should still be -32768");

	ok(S_OK == VarI2FromR8( 69.33, pShort ), XOK);
	ok(*pShort == 69, "should be 69");
	ok(S_OK == VarI2FromR8( 69.66, pShort ), XOK);
	ok(*pShort == 70, "should be 70");
	ok(S_OK == VarI2FromR8( -69.33, pShort ), XOK);
	ok(*pShort == -69, "should be -69");
	ok(S_OK == VarI2FromR8( -69.66, pShort ), XOK);
	ok(*pShort == -70, "should be -70");
	ok(S_OK == VarI2FromDate( -69.66, pShort ), XOK);
	ok(*pShort == -70, "should be -70");

	for( i = 0; i < nOlePtrs; i ++ )
	{
		char msg[200];
		sprintf(msg,"offset %d, expected return 0x%lx",i,strrets_I2[i].error);
		ok(strrets_I2[i].error == VarI2FromStr( pOleChar[i], 0, 0, pShort ), msg);
		sprintf(msg,"offset %d, expect retval %d",i,strrets_I2[i].retval);
		ok(strrets_I2[i].retval == *pShort,msg);
	}

	/* long from ...
	 */
	trace( "\n\n======== Testing VarI4FromXXX ========\n");

	ok(S_OK == VarI4FromI2( 3, (long*)pInt ), XOK);
	ok(*pInt == 3,"should be 3");

	ok(S_OK == VarI4FromR8( 69.33, pLong ), XOK);
	ok(*pLong == 69,"should be 69");
	ok(S_OK == VarI4FromR8( 69.66, pLong ), XOK);
	ok(*pLong == 70,"should be 70");
	ok(S_OK == VarI4FromR8( -69.33, pLong ), XOK);
	ok(*pLong == -69,"should be -69");
	ok(S_OK == VarI4FromR8( -69.66, pLong ), XOK);
	ok(*pLong == -70,"should be -70");

	ok(S_OK == VarI4FromR8( 2147483647.0, pLong ), XOK);
	ok(*pLong == 2147483647,"should be 2147483647");
	ok(DISP_E_OVERFLOW == VarI4FromR8( 2147483648.0, pLong ), XOV);
	ok(*pLong == 2147483647,"should still be 2147483647");

	ok(S_OK == VarI4FromR8( -2147483647.0, pLong ), XOK);
	ok(*pLong == -2147483647,"should be -2147483647");
	ok(S_OK == VarI4FromR8( -2147483648.0, pLong ), XOK);
	ok(*pLong == -2147483648,"should be -2147483648");
	ok(DISP_E_OVERFLOW == VarI4FromR8( -2147483649.0, pLong ), XOV);
	ok(*pLong == -2147483648,"should still be -2147483648");
	ok(DISP_E_OVERFLOW == VarI4FromDate( -2147483649.0, pLong ), XOV);
	ok(*pLong == -2147483648,"should still be -2147483648");

	for( i = 0; i < nOlePtrs; i ++ )
	{
	        char msg[200];

		sprintf(msg,"offset %d, should have retcode %lx",i,strrets_I4[i].error);
		ok(strrets_I4[i].error == VarI4FromStr( pOleChar[i], 0, 0, pLong ), msg);
		sprintf(msg,"offset %d, should have retval %ld",i,strrets_I4[i].retval);
		ok(strrets_I4[i].retval == *pLong,msg);
	}

	/* float from ...
	 */
	trace( "\n\n======== Testing VarR4FromXXX ========\n");

	ok(S_OK == VarR4FromI4( 16777216, pFloat ), XOK);
	ok(16777216.0 == *pFloat,"should be 16777216.0");

	ok(S_OK == VarR4FromI4( 16777217, pFloat ), XOK);
	ok(16777216.0 == *pFloat,"should be 16777216.0");
	ok(S_OK == VarR4FromI4( -16777216, pFloat ), XOK);
	ok(-16777216.0 == *pFloat,"should be -16777216.0");
	ok(S_OK == VarR4FromI4( -16777217, pFloat ), XOK);
	ok(-16777216.0 == *pFloat,"should be -16777216.0");

	ok(S_OK == VarR4FromR8( 16777216.0, pFloat ), XOK);
	ok(16777216.0 == *pFloat,"should be 16777216.0");
	ok(S_OK == VarR4FromR8( 16777217.0, pFloat ), XOK);
	ok(16777216.0 == *pFloat,"should be 16777216.0");
	ok(S_OK == VarR4FromR8( -16777216.0, pFloat ), XOK);
	ok(-16777216.0 == *pFloat,"should be -16777216.0");
	ok(S_OK == VarR4FromR8( -16777217.0, pFloat ), XOK);
	ok(-16777216.0 == *pFloat,"should be -16777216.0");

	ok(S_OK == VarR4FromR8( 16777218e31, pFloat ), XOK);
	ok(*pFloat == 167772177736353110000000000000000000000.000000,
		"should be 167772177736353110000000000000000000000.000000");
	ok(DISP_E_OVERFLOW == VarR4FromR8( 16777218e32, pFloat ), XOV);
	ok(*pFloat == 167772177736353110000000000000000000000.000000,
		"should still be 167772177736353110000000000000000000000.000000");
	ok(S_OK == VarR4FromDate( 16777218e31, pFloat ), XOK);
	ok(*pFloat == 167772177736353110000000000000000000000.000000,
		"should be 167772177736353110000000000000000000000.000000");

	for( i = 0; i < nOlePtrs; i ++ )
	{
	        char msg[200];

		sprintf(msg,"offset %d, retcode should be 0x%08lx",i,strrets_R4[i].error);
		ok(strrets_R4[i].error == VarR4FromStr( pOleChar[i], 0, 0, pFloat ), msg);
		sprintf(msg,"offset %d, retval should be %f",i,strrets_R4[i].retval);
		ok(strrets_R4[i].retval == *pFloat,msg);
	}

	/* double from ...
	 */
	trace( "\n\n======== Testing VarR8FromXXX ========\n");

	ok(S_OK == VarR8FromDate( 900719925474099.0, pDouble ), XOK);
	ok(*pDouble == 900719925474099.000000,"should be 900719925474099.000000\n");
	for( i = 0; i < nOlePtrs; i ++ )
	{
	        char msg[200];

		sprintf(msg,"offset %d, retcode should be 0x%lx",i,strrets_R8[i].error);
		ok(strrets_R8[i].error == VarR8FromStr( pOleChar[i], 0, 0, pDouble ), msg);
		sprintf(msg,"offset %d, retval should be %g",i,strrets_R8[i].retval);
		ok(strrets_R8[i].retval == *pDouble,msg);
	}

	/* date from ...
	 */
	trace( "\n\n======== Testing VarDateFromXXX ========\n");

	ok(S_OK == VarDateFromI4( 2958465, pDouble ), XOK);
	ok(*pDouble == 2958465.000000,"should be 2958465.000000");
	ok(DISP_E_OVERFLOW == VarDateFromI4( 2958466, pDouble ), XOV);
	ok(*pDouble == 2958465.000000,"should still be 2958465.000000");
	ok(S_OK == VarDateFromI4( -657434, pDouble ), XOK);
	ok(*pDouble == -657434.000000,"should be -657434.000000");
	ok(DISP_E_OVERFLOW == VarDateFromI4( -657435, pDouble ), XOV);
	ok(*pDouble == -657434.000000,"should still be -657434.000000");

	ok(S_OK == VarDateFromR8( 2958465.9999, pDouble ), XOK);
	ok(*pDouble == 2958465.999900, "should be 2958465.999900");
	ok(DISP_E_OVERFLOW == VarDateFromR8( 2958466, pDouble ), XOV);
	ok(*pDouble == 2958465.999900, "should still be 2958465.999900");
	ok(S_OK == VarDateFromR8( -657434.9999, pDouble ), XOK);
	ok(*pDouble == -657434.999900,"should be -657434.999900");
	ok(DISP_E_OVERFLOW == VarDateFromR8( -657435, pDouble ), XOV);
	ok(*pDouble == -657434.999900,"should still be -657434.999900");

	ok(S_OK == VarDateFromR8( 0.0, pDouble ), XOK);
	ok(*pDouble == 0.0,"0.0 should be 0.0");
	ok(S_OK == VarDateFromR8( 1.0, pDouble ), XOK);
	ok(*pDouble == 1.0,"1.0 should be 1.0");
	ok(S_OK == VarDateFromR8( 2.25, pDouble ), XOK);
	ok(*pDouble == 2.25,"2.25 should be 2.25");
	ok(S_OK == VarDateFromR8( -2.0, pDouble ), XOK);
	ok(*pDouble == -2.0,"-2.0 should be -2.0");

	/* Need some parsing function in Linux to emulate this...
	 * Still in progess.
	 */
#ifdef FIXED_DATE_FUNCTIONS
	for( i = 0; i < nOlePtrs; i ++ )
	{
		char msg[200];
		DWORD retcode;

		retcode = VarDateFromStr( pOleChar[i], 0, 0, pDouble );
		sprintf(msg,"offset %d, string %s, retcode should be 0x%lx, but was 0x%lx",i,WtoA(pOleChar[i]),strrets_DATE[i].error,retcode);
		ok(strrets_DATE[i].error == retcode, msg);
		sprintf(msg,"offset %d, retval %g ",i,strrets_DATE[i].retval);
		ok(*pDouble == strrets_DATE[i].retval,msg);
	}
#endif
	/* bool from ...
	 */
	trace( "\n\n======== Testing VarBoolFromXXX ========\n");

	ok(S_OK == VarBoolFromI4( 0, pBool ), XOK);
	ok(VARIANT_FALSE == *pBool, "expected FALSE");
	ok(S_OK == VarBoolFromI4( 1, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");
	ok(S_OK == VarBoolFromI4( -1, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");
	ok(S_OK == VarBoolFromI4( 2, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");

	ok(S_OK == VarBoolFromUI1( ' ', pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");
	ok(S_OK == VarBoolFromUI1( '\0', pBool ), XOK);
	ok(VARIANT_FALSE == *pBool, "expected FALSE");
	ok(S_OK == VarBoolFromUI1( 0x0000, pBool ), XOK);
	ok(VARIANT_FALSE == *pBool, "expected FALSE");
	ok(S_OK == VarBoolFromUI1( (unsigned char)0xFFF, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");
	ok(S_OK == VarBoolFromUI1( (unsigned char)0xFFFF, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");

	ok(S_OK == VarBoolFromR8( 0.0, pBool ), XOK);
	ok(VARIANT_FALSE == *pBool, "expected FALSE");
	ok(S_OK == VarBoolFromR8( 1.1, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");
	ok(S_OK == VarBoolFromR8( 0.5, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");
	ok(S_OK == VarBoolFromR8( 0.49, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");
	ok(S_OK == VarBoolFromR8( 0.51, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");
	ok(S_OK == VarBoolFromR8( -0.5, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");
	ok(S_OK == VarBoolFromR8( -0.49, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");
	ok(S_OK == VarBoolFromR8( -0.51, pBool ), XOK);
	ok(VARIANT_TRUE == *pBool, "expected TRUE");


	for( i = 0; i < nOlePtrs; i ++ )
	{
	    	char msg[200];

		sprintf(msg,"offset %d, retcode should be 0x%lx",i,strrets_B[i].error);
		ok(strrets_B[i].error == VarBoolFromStr( pOleChar[i], 0, 0, pBool ), msg);
		sprintf(msg,"offset %d, retval should be 0x%x",i,strrets_B[i].retval);
		ok(strrets_B[i].retval == *pBool,msg);
	}

	ok(S_OK == VarI1FromBool( VARIANT_TRUE, pByte ), XOK);
	ok(*pByte == 0xff,"true should be 0xff");
	ok(DISP_E_OVERFLOW == VarUI2FromI2( -1, pUShort ), XOV);

	/* BSTR from ...
	 */
	trace( "\n\n======== Testing VarBSTRFromXXX ========\n");

	/* integers...
	 */
	ok(S_OK == VarBstrFromI1( -100, 0, 0, &bstr ), XOK);
	ok(!strcmp(WtoA(bstr),"\"-100\""),"should be string -100");

	ok(S_OK == VarBstrFromUI1( 0x5A, 0, 0, &bstr ), XOK);
	ok(!strcmp(WtoA(bstr),"\"90\""),"should be string 90");
	ok(S_OK == VarBstrFromI4( 2958465, 0, 0, &bstr ), XOK);
	ok(!strcmp(WtoA(bstr),"\"2958465\""),"should be string 2958465");

	/* reals...
	 */
	off = 0;
	d=0;
	for( i=0; i<20; i++ )
	{
	        char xval[80];
		/* add an integer to the real number
		 */
		d += ((i%9)+1) * pow( 10, i );

		ok(S_OK == VarBstrFromR8( d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;

		ok(S_OK == VarBstrFromR8( -d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",-d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
	}
	d=0;
	for( i=0; i<20; i++ )
	{
	        char xval[80];
		/* add a decimal to the real number
		 */
		d += ((i%9)+1) * pow( 10, (i*-1) );
		ok(S_OK == VarBstrFromR8( d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
		ok(S_OK == VarBstrFromR8( d-1, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",d-1,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
		ok(S_OK == VarBstrFromR8( -d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",-d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
	}

	d=0;
	for( i=0; i<20; i++ )
	{
	        char xval[80];
		/* add an integer to the real number
		 */
		d += ((i%9)+1) * pow( 10, i );
		/* add a decimal to the real number
		 */
		d += ((i%9)+1) * pow( 10, (i*-1) );
		ok(S_OK == VarBstrFromR8( d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
		ok(S_OK == VarBstrFromR8( -d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",-d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
	}



	d=0;
	for( i=0; i<10; i++ )
	{
	        char xval[80];
		/* add an integer to the real number
		 */
		d += ((i%9)+1) * pow( 10, i );
		ok(S_OK == VarBstrFromR4( (float)d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
		ok(S_OK == VarBstrFromR4( (float)-d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",-d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
	}
	d=0;
	for( i=0; i<10; i++ )
	{
	        char xval[80];
		/* add a decimal to the real number
		 */
		d += ((i%9)+1) * pow( 10, (i*-1) );
		ok(S_OK == VarBstrFromR4( (float)d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
		ok(S_OK == VarBstrFromR4( (float)d-1, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",d-1,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
		ok(S_OK == VarBstrFromR4( (float)-d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",-d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
	}

	d=0;
	for( i=0; i<10; i++ )
	{
	        char xval[80];
		/* add an integer to the real number
		 */
		d += ((i%9)+1) * pow( 10, i );
		/* add a decimal to the real number
		 */
		d += ((i%9)+1) * pow( 10, (i*-1) );
		ok(S_OK == VarBstrFromR4( (float)d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
		ok(S_OK == VarBstrFromR4( (float)-d, 0, 0, &bstr ), XOK);
		sprintf(msg,"d is %g, should be cvt. to %s, but return val is %s",-d,strfromr8[off],WtoA(bstr));
		sprintf(xval,"\"%s\"",strfromr8[off]);
		ok(!strcmp(xval,WtoA(bstr)),msg);off++;
	}

	ok(S_OK == VarBstrFromBool( 0x00, 0, 0, &bstr ), XOK);
	ok(!strcmp(WtoA(bstr),"\"False\""),"should be 'False'");
	ok(S_OK == VarBstrFromBool( 0xFF, 0, 0, &bstr ), XOK);
	ok(!strcmp(WtoA(bstr),"\"True\""),"should be 'True'");

	ok(S_OK == VarBstrFromDate( 0.0, 0, 0, &bstr ), XOK);
	todo_wine {
	    sprintf(msg,"should be '12:00:00 AM', but is %s\n",WtoA(bstr));
	    ok(!strcmp(WtoA(bstr),"\"12:00:00 AM\""),msg);
	}

	ok(S_OK == VarBstrFromDate( 3.34, 0, 0, &bstr ), XOK);
	todo_wine {
	    sprintf(msg,"should be '1/2/1900 8:09:36 AM', but is %s\n",WtoA(bstr));
	    ok(!strcmp(WtoA(bstr),"\"1/2/1900 8:09:36 AM\""),msg);
	}

	ok(S_OK == VarBstrFromDate( 3339.34, 0, 0, &bstr ), XOK);
	todo_wine {
	    sprintf(msg,"should be '2/20/1909 8:09:36 AM', but is %s\n",WtoA(bstr));
	    ok(!strcmp(WtoA(bstr),"\"2/20/1909 8:09:36 AM\""),msg);
	}

	ok(S_OK == VarBstrFromDate( 365.00, 0, 0, &bstr ), XOK);
	todo_wine {
	    sprintf(msg,"should be '12/30/1900', but is %s\n",WtoA(bstr));
	    ok(!strcmp(WtoA(bstr),"\"12/30/1900\""),msg);
	}

	ok(S_OK == VarBstrFromDate( 365.25, 0, 0, &bstr ), XOK);
	todo_wine {
	    sprintf(msg,"should be '12/30/1900 6:00:00 AM', but is %s\n",WtoA(bstr));
	    ok(!strcmp(WtoA(bstr),"\"12/30/1900 6:00:00 AM\""),msg);
	}

	ok(S_OK == VarBstrFromDate( 1461.0, 0, 0, &bstr ), XOK);
	todo_wine {
	    sprintf(msg,"should be '12/31/1903', but is %s\n",WtoA(bstr));
	    ok(!strcmp(WtoA(bstr),"\"12/31/1903\""),msg);
	}

	ok(S_OK == VarBstrFromDate( 1461.5, 0, 0, &bstr ), XOK);
	todo_wine {
	    sprintf(msg,"should be '12/31/1903 12:00:00 PM', but is %s\n",WtoA(bstr));
	    ok(!strcmp(WtoA(bstr),"\"12/31/1903 12:00:00 PM\""),msg);
	}

	/* Test variant API...
	 */
	trace( "\n\n======== Testing Hi-Level Variant API ========\n");

	bstr = SysAllocString( pOleChar[4] );

	VariantClear( &va );

	VariantInit( &va );
	VariantInit( &vb );
	VariantInit( &vc );
	VariantInit( &vd );
	VariantInit( &ve );

	V_VT(&va) = VT_BSTR;
	V_UNION(&va,bstrVal) = bstr;
	ok(S_OK == VariantClear( &va ), XOK);
	SysFreeString( bstr );
	SysFreeString( bstr );

	ok(S_OK == VariantCopy( &vb, &va ), XOK);
	ok(S_OK == VariantClear( &vb ), XOK);
	ok(S_OK == VariantClear( &va ), XOK);

	V_VT(&va) = VT_R8;
	d = 4.123;
	V_UNION(&va,dblVal) = d;
	ok(S_OK == VariantCopy( &va, &va ), XOK);
	ok(V_R8(&va) == 4.123,"should be 4.123");

	V_VT(&va) = VT_R8 | VT_BYREF;
	d = 31.123;
	V_UNION(&va,pdblVal) = &d;
	ok(S_OK == VariantCopyInd( &va, &va ), XOK);
	ok(V_R8(&va) == 31.123,"should be 31.123");

	V_VT(&va) = VT_R8;
	d = 1.123;
	V_UNION(&va,dblVal) = d;
	ok(S_OK == VariantCopy( &vb, &va ), XOK);
	ok(V_R8(&vb) == 1.123,"should be 1.123");

	V_VT(&va) = VT_R8 | VT_BYREF;
	d = 123.123;
	V_UNION(&va,pdblVal) = &d;
	ok(S_OK == VariantCopy( &vb, &va ), XOK);
	ok(*(V_R8REF(&vb)) == 123.123,"should be 123.123");

	V_VT(&va) = VT_R8 | VT_BYREF;
	d = 111.2;
	V_UNION(&va,pdblVal) = &d;
	ok(S_OK == VariantCopyInd( &vb, &va ), XOK);
	ok(V_R8(&vb) == 111.2,"should be 111.2");

	V_VT(&va) = VT_R8 | VT_BYREF;
	d = 1211.123453;
	V_UNION(&va,pdblVal) = &d;
	ok(S_OK == VariantChangeTypeEx( &va, &va, 0, 0, VT_I2 ), XOK);
	ok(V_VT(&va) == VT_I2,"should be type VT_I2");

	V_VT(&va) = VT_INT;
	V_UNION(&va,intVal) = 4;
	ok(S_OK == VariantChangeTypeEx(&vb, &va, 0, 0, VT_BSTR ), XOK);
	ok(!strcmp(WtoA(V_BSTR(&vb)),"\"4\""),"should be 4");

	V_VT(&va) = VT_DATE;
	V_UNION(&va,date) = 34465.332431;
	ok(S_OK == VariantChangeTypeEx(&vb, &va, 0, 0, VT_BSTR ), XOK);
	todo_wine {
	    ok(!strcmp(WtoA(V_BSTR(&vb)),"\"5/11/94 7:58:42 AM\""),"should be 5/11/94 7:58:42 AM");
	}

	bstr = pOleChar[4];
	V_VT(&va) = VT_BSTR;
	V_UNION(&va,bstrVal) = bstr;
	ok(S_OK == VariantChangeTypeEx(&vb, &va, 0, 0, VT_R8 ), XOK);
	ok(V_R8(&vb) == -0.490000,"should be -0.49");

	V_VT(&vc) = VT_BSTR | VT_BYREF;
	V_UNION(&vc,pbstrVal) = &bstr;
	V_VT(&vb) = VT_VARIANT | VT_BYREF;
	V_UNION(&vb,pvarVal) = &vc;
	V_VT(&va) = VT_VARIANT | VT_BYREF;
	V_UNION(&va,pvarVal) = &vb;
	ok(E_INVALIDARG == VariantCopyInd( &vd, &va ), "expect E_INVALIDARG");

	/* test what happens when bad vartypes are passed in */
	trace( "-------------- Testing different VARTYPES ----------------\n" );

#ifdef FIXED_THIS
	for( i=0; i<sizeof(vartypes)/sizeof(vartypes[0]); i++ )
	{
		    /* Trying to use variants that are set to be BSTR but
		     * do not contain a valid pointer makes the program crash
		     * in Windows so we will skip those. We do not need them
		     * anyway to illustrate the behavior.
		     */
		    V_VT(&va) = vartypes[i].ind;
		    d = 4.123;
		    V_UNION(&va,dblVal) = d;
		    res = VariantCopyInd( &vb, &va );
		    sprintf(msg,"vt %d, return value %lx, expected was %lx",vartypes[i].ind,res,vartypes[i].vcind1);
		    ok(vartypes[i].vcind1 == res, msg);
		    V_VT(&va) = vartypes[i].ind | VT_BYREF;
		    d = 4.123;
		    V_UNION(&va,pdblVal) = &d;
		    res = VariantCopyInd( &vb, &va );
		    sprintf(msg,"vt %d, return value %lx, expected was %lx",vartypes[i].ind,res,vartypes[i].vcind2);
		    ok(vartypes[i].vcind2 == res, msg);
		    V_VT(&va) = VT_R8;
		    d = 4.123;
		    V_UNION(&va,dblVal) = d;
		    res = VariantChangeTypeEx( &vb, &va, 0, 0, i );
		    sprintf(msg,"vt %d, return value %lx, expected was %lx",vartypes[i].ind,res,vartypes[i].vcex1);
		    ok(vartypes[i].vcex1 == res, msg);
		    V_VT(&va) = VT_R8;
		    d = 4.123;
		    V_UNION(&va,dblVal) = d;
		    res = VariantChangeTypeEx( &vb, &va, 0, 0, i | VT_BYREF );
		    sprintf(msg,"vt %d, return value %lx, expected was %lx",vartypes[i].ind,res,vartypes[i].vcex1);
		    ok(vartypes[i].vcex2 == res, msg);

		V_VT(&va) = 99;
		d = 4.123;
		V_UNION(&va,dblVal) = d;
		ok(DISP_E_BADVARTYPE == VariantClear( &va ), "should give DISP_E_BADVARTYPE");
	}
#endif
	VariantClear( &va );
	VariantClear( &vb );
	VariantClear( &vc );
	VariantClear( &vd );
	VariantClear( &ve );
	/* There is alot of memory leaks but this is simply a test program.
	 */
}
